package viPlugin;

import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

/**
 * <p>
 * Controls lifecycle of individual ViLayers.
 * </p>
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.1 $ $Date: 2003/11/10 22:25:52 $
 */
public class ViPartListener implements IPartListener {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPartListener#partActivated(org.eclipse.ui.IWorkbenchPart)
	 */
	public void partActivated(IWorkbenchPart part) {
//		System.out.println("ViPartListener:partActivated()");
		activateLayer(part);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPartListener#partBroughtToTop(org.eclipse.ui.IWorkbenchPart)
	 */
	public void partBroughtToTop(IWorkbenchPart part) {
//		System.out.println("ViPartListener:partBroughtToTop()");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPartListener#partClosed(org.eclipse.ui.IWorkbenchPart)
	 */
	public void partClosed(IWorkbenchPart part) {
//		System.out.println("ViPartListener:partClosed()");
		if (part instanceof ITextEditor) {
			ViLayerFactory.getInstance().removeViLayer((ITextEditor) part);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPartListener#partDeactivated(org.eclipse.ui.IWorkbenchPart)
	 */
	public void partDeactivated(IWorkbenchPart part) {
//		System.out.println("ViPartListener:partDeactivated()");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPartListener#partOpened(org.eclipse.ui.IWorkbenchPart)
	 */
	public void partOpened(IWorkbenchPart part) {
//		System.out.println("ViPartListener:partOpened()");
		activateLayer(part);
	}

	private void activateLayer(IWorkbenchPart part) {
		if (part instanceof ITextEditor) {
			ViLayerFactory.getInstance().activateLayer((ITextEditor) part);
		}
	}
}
