package viPlugin;

/**
 * Type-Safe enumeration of ViModes.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.2 $ $Date: 2003/11/25 08:21:19 $
 */
public class ViMode {

	private String _description;

	public static final ViMode VISUAL_MODE = new ViMode("Visual mode");
	public static final ViMode INSERT_MODE = new ViMode("Insert mode");
	public static final ViMode COMMAND_MODE = new ViMode("Command mode");

	private ViMode(String description) {
		_description = description;
	}

	/**
	 * Returns the description.
	 * 
	 * @return Returns the description.
	 */
	public String getDescription() {
		return _description;
	}

}
