/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 	
 * Created on 19.08.2003
 *******************************************************************************/
 
package viPlugin;


public class TextBuffer {
	private String text = new String();
	private boolean fullLines = false;

	public void fill(String text) {
		this.text = text;
		// fullLines is when the text ends with a delimiter
		fullLines = text.endsWith(TextModificator.getInstance().getDelimiter());
		// or when the text is the last text in the document!
		if (!fullLines) {
			String fullText = TextModificator.getInstance().getDocument().get();
			fullLines = fullText.lastIndexOf(text) == fullText.length() - text.length();
		}
	}

	public String getText() {
		return text;
	}

	public boolean getFullLines() {
		return fullLines;
	}
}

