/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on 26.05.2003
 *******************************************************************************/

package viPlugin;

import java.util.LinkedList;
import java.util.List;

public class CommandParser {
	/*
	 * _useCounter is set when _counter has been set explicitly in the command
	 * buffer (e.g. 20cw)
	 */
	public boolean _useCounter;
	/*
	 * _counter holds the number of command repitions. it is set to 1 if no
	 * _counter has been set explicitly
	 */
	public int _counter;
	public String _operation;
	public String _modifier;

	private String specialCommands[] =
		{
			"r",
			"dt",
			"dT",
			"df",
			"dF",
			"yt",
			"yT",
			"yf",
			"yF",
			"ct",
			"cT",
			"cf",
			"cF",
			"t",
			"f",
			"T",
			"F",
			"m",
			"Z",
			"%",
			"'" };

	private String commands[] =
		{
			"d",
			"D",
			"dd",
			"c",
			"S",
			"cc",
			"C",
			"y",
			"Y",
			"yy",
			"i",
			"I",
			"a",
			"A",
			"o",
			"O",
			"s",
			"v",
			"V",
			"<CD>",
			"<CU>",
			"<CL>",
			"<CR>",
			"<PD>",
			"<PU>",
			"<SD>",
			"<SU>",
			"h",
			"j",
			"k",
			"l",
			"H",
			"L",
			"M",
			"0",
			"^",
			"$",
			"w",
			"b",
			"e",
			"E",
			"gg",
			"G",
			"*",
			"#",
			"J",
			"<<",
			">>",
			"~",
			"x",
			"X",
			"p",
			"P",
			"n",
			"N",
			";",
			",",
			".",
			"u",
			"<REDO>",
			" ",
			ViVerifyKeyListener.ENTER_STRING };

	private String modifiers[] =
		{
			"0",
			"^",
			"$",
			"w",
			"b",
			"e",
			"d",
			"E",
			"t",
			"T",
			"f",
			"F",
			"h",
			"j",
			"k",
			"l",
			";",
			",",
			"<CU>",
			"<CD>",
			"/" };

	private boolean checkValidity(String command) {
		for (int i = 0; i < specialCommands.length; i++) {
			String verifyCommand = specialCommands[i];
			if (verifyCommand.length() <= command.length()
				&& verifyCommand.startsWith(
					command.substring(0, verifyCommand.length())))
				return true;
		}

		int cmdLength = command.length();
		for (int i = 0; i < commands.length; i++) {
			for (int j = 0; j < modifiers.length; j++) {
				String verifyCommand = commands[i] + modifiers[j];
				if (verifyCommand.length() >= cmdLength
					&& command.startsWith(
						verifyCommand.substring(0, cmdLength))) {
					return true;
				}
			}
		}
		return false;
	}

	private List splitString(String str) {
		List strList = new LinkedList();
		boolean mode = Character.isDigit(str.charAt(0));
		String part = "";
		for (int i = 0; i < str.length(); i++) {
			if (mode == true && Character.isDigit(str.charAt(i))) {
				part += str.charAt(i);
			} else if (mode == false && !Character.isDigit(str.charAt(i))) {
				part += str.charAt(i);
			} else {
				strList.add(part);
				part = "";
				part += str.charAt(i);
				mode = !mode;
			}
		}
		strList.add(part);
		return strList;
	}

	/**
	 * Set _counter (how often the command should be invoked e.g. 300dd) In vi
	 * there can exist 2 counters like in 3d3d which kill 3*3 lines. Same as
	 * 9dd or d9d
	 * 
	 * @param command
	 *            given
	 * @return command without _counter information (3d3d => dd)
	 */
	private String formatCommand(String command) {
		String result = "";
		List list = splitString(command);
		for (int i = 0; i < list.size(); i++) {
			String part = (String) list.get(i);
			if (!Character.isDigit(part.charAt(0))) {
				result += part;
			} else {
				// if the last part is a digit and a special command
				// then it's part of the command itself (e.g. r3 NOT d3)
				if (list.size() - 1 == i) {
					for (int j = 0; j < specialCommands.length; j++) {
						String verifyCommand = specialCommands[j];
						if (verifyCommand.length() <= result.length()
							&& verifyCommand.startsWith(
								result.substring(0, verifyCommand.length())))
							result += part;
					}

				} else {
					_counter *= Integer.parseInt(part);
					_useCounter = true;
				}
			}
		}

		return result;
	}

	/**
	 * DOCDO
	 * 
	 * @param command
	 * @return true if command is valid
	 */
	public boolean parse(String command) {
		_useCounter = false;
		// commands are executed once
		_counter = 1;
		_operation = "";
		_modifier = "";

		// these commands have to be treated specialy
		if (command.equals("0")
			|| command.startsWith("/")
			|| command.startsWith(":")) {
			_operation = command;
		} else if (command.equals("d0")) {
			_operation = "d";
			_modifier = "0";
		} else {
			_operation = formatCommand(command);
			if (!checkValidity(_operation)) {
				return false;
			}
		}

		// get operation modifier
		if (_operation.length() > 1) {
			_modifier = _operation.substring(1);
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "_useCounter: "
			+ _useCounter
			+ ", _counter: "
			+ _counter
			+ ", _operation: "
			+ _operation
			+ ", _modifier: "
			+ _modifier;
	}
}
