/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.swingui.TestRunner;
import viPlugin.TextModificator;
import viPlugin.test.SharedTestResources;

public class TextModificatorTest
extends TestCase {
    private TextModificator t;
    private final String simpleString = "This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class";
    static /* synthetic */ Class class$0;

    public TextModificatorTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("viPlugin.test.TextModificatorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        SharedTestResources.setConfiguredTextModificator("This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class");
        this.t = TextModificator.getInstance();
    }

    public final void testCursorLeft() {
        this.t.cursorToLineEnd();
        int cursorPos = this.t.cursorLeft(3);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("ome"), (int)cursorPos);
        cursorPos = this.t.cursorLeft(100);
        this.t.getLine();
        Assert.assertEquals((int)0, (int)cursorPos);
    }

    public final void testCursorRight() {
        int cursorPos = this.t.cursorRight(3);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("s is a"), (int)cursorPos);
        cursorPos = this.t.cursorRight(100);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("\r\nTo test"), (int)cursorPos);
    }

    public final void testCursorToLine() {
        int cursorPos = this.t.cursorToLine(0, true);
        Assert.assertEquals((int)0, (int)cursorPos);
        cursorPos = this.t.cursorToLine(1, true);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("To test"), (int)cursorPos);
        cursorPos = this.t.cursorToLine(3, true);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("the TextModification class"), (int)cursorPos);
        cursorPos = this.t.cursorToLine(100, true);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("the TextModification class"), (int)cursorPos);
    }

    public final void testCursorWordBack() {
    }

    public final void testCursorWordEnd() {
        int cursorPos = this.t.cursorWordEnd(2);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("s a simple"), (int)cursorPos);
        cursorPos = this.t.cursorWordEnd(1);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("a simple.three()"), (int)cursorPos);
        cursorPos = this.t.cursorWordEnd(1);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("e.three()"), (int)cursorPos);
        cursorPos = this.t.cursorWordEnd(1);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf(".three()"), (int)cursorPos);
        cursorPos = this.t.cursorWordEnd(1);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("e()  line"), (int)cursorPos);
        cursorPos = this.t.cursorWordEnd(1);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf(")  line"), (int)cursorPos);
        cursorPos = this.t.cursorWordEnd(1);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("e>string"), (int)cursorPos);
        cursorPos = this.t.cursorWordEnd(2);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("g (  ) become"), (int)cursorPos);
        cursorPos = this.t.cursorWordEnd(1);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf("(  ) become"), (int)cursorPos);
        cursorPos = this.t.cursorWordEnd(1);
        Assert.assertEquals((int)"This is a simple.three()  line>string (  ) become\r\nTo test the functionality of\r\nthe TextModification class".indexOf(") become"), (int)cursorPos);
    }

    public final void testPaste() {
    }

    public final void testSearchNext() {
    }

    public final void testSearchPrevious() {
    }

    public final void testSearch() {
    }

    public final void testSearchCurrentWord() {
    }

    public final void testSearchCurrentWordBackwards() {
    }

    public final void testGetNextWord() throws Exception {
        String s0 = "Everyone thinks of changing the world, but no one thinks of changing himself.";
        int wordSum = 0;
        int wordIdx = 0;
        do {
            wordIdx = this.t.getNextWord(s0, wordIdx);
            ++wordSum;
        } while (wordIdx < s0.length() - 1);
        Assert.assertEquals((int)14, (int)wordSum);
        String s1 = "f(x) = mx + b";
        wordSum = 0;
        wordIdx = 0;
        do {
            wordIdx = this.t.getNextWord(s1, wordIdx);
            ++wordSum;
        } while (wordIdx < s1.length() - 1);
        Assert.assertEquals((int)7, (int)wordSum);
        String s2 = "Supercalifragalisticexpialadocious";
        Assert.assertEquals((int)(s2.length() - 1), (int)this.t.getNextWord(s2, 0));
        String s3 = "";
        Assert.assertEquals((int)0, (int)this.t.getNextWord(s3, 0));
    }

    public final void testGetPreviousWord() throws Exception {
    }

    public final void testCursorToLineEnd() throws Exception {
    }
}

