/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import viPlugin.TextModificator;
import viPlugin.commands.Command;
import viPlugin.commands.motion.GoToFirstLine;
import viPlugin.commands.motion.GoToLastLine;
import viPlugin.commands.motion.MoveDown;
import viPlugin.commands.motion.MoveUp;
import viPlugin.test.SharedTestResources;

public class MotionCommandsTest
extends TestCase {
    private TextModificator _tm;
    private final String _documentContent = "1. first second, third, ..., last\r\n2. ffirst, ssecond, tthird, ..., llast\r\n3. ffirst, ssecond, tthird, ..., llast\r\n4. ffirst, ssecond, tthird, ..., llast";

    public MotionCommandsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        SharedTestResources.setConfiguredTextModificator("1. first second, third, ..., last\r\n2. ffirst, ssecond, tthird, ..., llast\r\n3. ffirst, ssecond, tthird, ..., llast\r\n4. ffirst, ssecond, tthird, ..., llast");
        this._tm = TextModificator.getInstance();
    }

    public void testMoveDown() {
        GoToFirstLine goToFirstLine = new GoToFirstLine();
        ((Command)goToFirstLine).execute();
        int pos = this._tm.getLinePos();
        Assert.assertEquals((int)pos, (int)0);
        MoveDown moveDown = new MoveDown(2);
        ((Command)moveDown).execute();
        Assert.assertEquals((int)(pos += 2), (int)this._tm.getLinePos());
        MoveDown moveDown1 = new MoveDown(1);
        boolean isLastLine = this._tm.getLinePos() + 1 == this._tm.getDocument().getNumberOfLines();
        ((Command)moveDown1).execute();
        if (isLastLine) {
            Assert.assertEquals((int)pos, (int)this._tm.getLinePos());
        } else {
            Assert.assertEquals((int)(++pos), (int)this._tm.getLinePos());
        }
        MoveDown moveDown100k = new MoveDown(100000);
        ((Command)moveDown100k).execute();
        Assert.assertEquals((int)(this._tm.getDocument().getNumberOfLines() - 1), (int)this._tm.getLinePos());
        Assert.assertEquals((String)"4. ffirst, ssecond, tthird, ..., llast", (String)this._tm.getLineText());
    }

    public void testMoveUp() {
        GoToLastLine goToLastLine = new GoToLastLine();
        ((Command)goToLastLine).execute();
        int pos = this._tm.getLinePos();
        Assert.assertEquals((int)pos, (int)(this._tm.getDocument().getNumberOfLines() - 1));
        Assert.assertEquals((String)"4. ffirst, ssecond, tthird, ..., llast", (String)this._tm.getLineText());
        MoveUp moveUp2 = new MoveUp(2);
        ((Command)moveUp2).execute();
        Assert.assertEquals((int)(pos -= 2), (int)this._tm.getLinePos());
        MoveUp moveUp100k = new MoveUp(100000);
        ((Command)moveUp100k).execute();
        Assert.assertEquals((int)0, (int)this._tm.getLinePos());
        Assert.assertEquals((String)"1. first second, third, ..., last", (String)this._tm.getLineText());
    }
}

