/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import viPlugin.TextModificator;
import viPlugin.commands.MatchBrace;
import viPlugin.commands.search.RegExSearch;
import viPlugin.test.SharedTestResources;

public class MatchBraceTest
extends TestCase {
    private TextModificator _tm;
    private final String _documentContent = "[ { 1{ 2 { 3 } 4 } 5 } ] ( )()";

    protected void setUp() throws Exception {
        SharedTestResources.setConfiguredTextModificator("[ { 1{ 2 { 3 } 4 } 5 } ] ( )()");
        this._tm = TextModificator.getInstance();
    }

    public void testExecute() {
        if (RegExSearch.isSupported(false)) {
            this._tm.setVisualSelection(1, 1);
            MatchBrace mb = new MatchBrace();
            mb.execute();
            int pos = this._tm.getCaretPosition();
            Assert.assertEquals((int)2, (int)pos);
            this._tm.setVisualSelection(0, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = this._tm.getCaretPosition();
            Assert.assertEquals((int)23, (int)pos);
            this._tm.setVisualSelection(2, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = this._tm.getCaretPosition();
            Assert.assertEquals((int)21, (int)pos);
            this._tm.setVisualSelection(27, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = this._tm.getCaretPosition();
            Assert.assertEquals((int)25, (int)pos);
            this._tm.setVisualSelection(29, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = this._tm.getCaretPosition();
            Assert.assertEquals((int)28, (int)pos);
            this._tm.setVisualSelection(17, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = this._tm.getCaretPosition();
            Assert.assertEquals((int)5, (int)pos);
        }
    }
}

