/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import viPlugin.TextModificator;
import viPlugin.commands.Command;
import viPlugin.commands.delete.DeleteWordForward;
import viPlugin.commands.motion.GoToFirstLine;
import viPlugin.test.SharedTestResources;

public class DeleteCommandsTest
extends TestCase {
    private TextModificator _tm;
    private final String _documentContent = "1. first second, third, ..., last\r\n2. ffirst, ssecond, tthird, ..., llast\r\n3. ffirst, ssecond, tthird, ..., llast\r\n4. ffirst, ssecond, tthird, ..., llast";

    public DeleteCommandsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        SharedTestResources.setConfiguredTextModificator("1. first second, third, ..., last\r\n2. ffirst, ssecond, tthird, ..., llast\r\n3. ffirst, ssecond, tthird, ..., llast\r\n4. ffirst, ssecond, tthird, ..., llast");
        this._tm = TextModificator.getInstance();
    }

    public void testDeleteWordForward() {
        GoToFirstLine goToFirstLine = new GoToFirstLine();
        ((Command)goToFirstLine).execute();
        DeleteWordForward dw = new DeleteWordForward(1);
        ((Command)dw).execute();
        Assert.assertEquals((String)". first second, third, ..., last", (String)this._tm.getLineText());
        ((Command)dw).undo();
        DeleteWordForward dw3 = new DeleteWordForward(3);
        ((Command)dw3).execute();
        Assert.assertEquals((String)"second, third, ..., last", (String)this._tm.getLineText());
        ((Command)dw3).undo();
        Assert.assertEquals((String)"1. first second, third, ..., last", (String)this._tm.getLineText());
    }
}

