/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import viPlugin.ViPluginPlugin;
import viPlugin.preferences.commands.AbstractSetPrefCommand;
import viPlugin.preferences.commands.SetBoolean;
import viPlugin.preferences.commands.SetPrefCommand;
import viPlugin.preferences.commands.UnSetBoolean;

public class ViPreferenceService {
    private static ViPreferenceService _instance;
    private Preferences _preferences = ViPluginPlugin.getDefault().getPluginPreferences();
    private Map _prefCommands;

    private void initCommandMappings() {
        this._prefCommands = new HashMap();
        Map pf = this._prefCommands;
        AbstractSetPrefCommand c = null;
        c = new SetBoolean("ignorecase");
        pf.put("ic", c);
        pf.put("ignorecase", c);
        c = new UnSetBoolean("ignorecase");
        pf.put("noic", c);
        pf.put("noignorecase", c);
        c = new SetBoolean("vimcursor");
        pf.put("vc", c);
        pf.put("vimcursor", c);
        c = new UnSetBoolean("vimcursor");
        pf.put("novc", c);
        pf.put("novimcursor", c);
    }

    private ViPreferenceService() {
        this.initCommandMappings();
    }

    public static ViPreferenceService getInstance() {
        if (_instance == null) {
            _instance = new ViPreferenceService();
        }
        return _instance;
    }

    public void eval(String name, String value) {
        SetPrefCommand command = (SetPrefCommand)this._prefCommands.get(name);
        command.execute(value);
    }

    public boolean getBoolean(String name) {
        return this._preferences.getBoolean(name);
    }

    public String getString(String name) {
        return this._preferences.getString(name);
    }

    public int getInt(String name) {
        return this._preferences.getInt(name);
    }
}

