/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.editors;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import viPlugin.CommandBuffer;
import viPlugin.ILayerInterface;

public class ViEditor
extends TextEditor
implements ILayerInterface {
    private IStatusLineManager slm;
    private static CommandBuffer commandBuffer;
    private NewVerifyKeyListener newVerifyKeyListener;
    private StyledText textWidget;
    private short mode;
    private final short COMMANDMODE = 0;
    private final short INSERTMODE = 1;
    private final short VISUALMODE = (short)2;

    public ViEditor() {
        this.newVerifyKeyListener = new NewVerifyKeyListener();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.slm = this.getEditorSite().getActionBars().getStatusLineManager();
        this.textWidget = this.getSourceViewer().getTextWidget();
        this.textWidget.addVerifyKeyListener((VerifyKeyListener)this.newVerifyKeyListener);
        this.mode = 0;
    }

    private void setStatusLine() {
        String message = new String();
        message = this.mode == 0 ? "CommandMode: CommandBuffer = " + commandBuffer.getCommand() : (this.mode == 1 ? "InsertMode" : (this.mode == 2 ? "VisualMode" : "MODE NOT SUPPORTED - SOMETHING IS VERY WRONG!"));
        this.slm.setMessage(message);
    }

    public void switchToCommandMode() {
        this.mode = 0;
        commandBuffer.clear();
        this.setStatusLine();
    }

    public void switchToInsertMode() {
        this.mode = 1;
        commandBuffer.clear();
        this.setStatusLine();
    }

    public void unLoad() {
    }

    public void switchToVisualMode() {
    }

    private class NewVerifyKeyListener
    implements VerifyKeyListener {
        NewVerifyKeyListener() {
        }

        public void verifyKey(VerifyEvent e) {
            if (e.character == '\u001b') {
                e.display.getActiveShell().setImeInputMode(0);
                if (ViEditor.this.mode == 1) {
                    ViEditor.this.mode = (short)0;
                }
                commandBuffer.clear();
                ViEditor.this.setStatusLine();
                e.doit = false;
            } else if (ViEditor.this.mode == 0) {
                switch (e.character) {
                    case '\u0000': {
                        e.doit = true;
                        break;
                    }
                    case '\b': {
                        commandBuffer.backspace();
                        commandBuffer.eval();
                        ViEditor.this.setStatusLine();
                        e.doit = false;
                        break;
                    }
                    case '\r': {
                        e.display.getActiveShell().setImeInputMode(0);
                        commandBuffer.append(e.character);
                        commandBuffer.eval();
                        ViEditor.this.setStatusLine();
                        e.doit = false;
                        break;
                    }
                    default: {
                        commandBuffer.append(e.character);
                        commandBuffer.eval();
                        ViEditor.this.setStatusLine();
                        e.doit = false;
                    }
                }
            }
        }
    }
}

