/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands.select;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import viPlugin.TextModificator;
import viPlugin.commands.select.SelectionCommand;

public class SelectLines
extends SelectionCommand {
    private int lines;
    private boolean checkLastDelimiter;
    private int direction;
    public static final int UP = 0;
    public static final int DOWN = 1;

    public SelectLines(int lines, int direction, boolean checkLastDelimiter) {
        this.lines = lines;
        this.checkLastDelimiter = checkLastDelimiter;
        this.direction = direction;
    }

    public void execute() {
        TextModificator tm = TextModificator.getInstance();
        try {
            IRegion endLine;
            int endLinePos;
            IRegion startLine;
            if (this.direction == 1) {
                startLine = tm.getLine();
                int startLinePos = tm.getLinePos();
                endLinePos = startLinePos + this.lines - 1;
                if (tm.getDocument().getNumberOfLines() <= endLinePos + 1) {
                    endLinePos = tm.getDocument().getNumberOfLines() - 1;
                    if (this.checkLastDelimiter && startLinePos > 0) {
                        tm.setDeleteLastDelimiter(true);
                    }
                }
                endLine = tm.getDocument().getLineInformation(endLinePos);
            } else {
                endLinePos = tm.getDocument().getLineOfOffset(tm.getCaretPosition());
                endLine = tm.getDocument().getLineInformation(endLinePos);
                int startLinePos = endLinePos - this.lines;
                if (startLinePos < 0) {
                    startLinePos = 0;
                }
                startLine = tm.getDocument().getLineInformation(startLinePos);
            }
            String delim = tm.getLineDelimiter(endLinePos);
            int start = startLine.getOffset();
            int length = endLine.getOffset() + endLine.getLength() - start + delim.length();
            tm.setInternalSelection(start, length);
            tm.deactivateVisualMode();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

