/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands.search;

import viPlugin.TextModificator;
import viPlugin.commands.Command;
import viPlugin.commands.search.ISearch;

public class SearchDelegate {
    private ISearch _search;
    private boolean _searchFinished;
    private Command _postCommand;

    public SearchDelegate(ISearch search) {
        this._search = search;
        this._searchFinished = false;
    }

    public SearchDelegate(ISearch search, Command postCommand) {
        this(search);
        this._postCommand = postCommand;
    }

    public boolean search(String o) throws Exception {
        if (o.length() > 1) {
            if (o.endsWith(String.valueOf('\u001b'))) {
                this._searchFinished = true;
                TextModificator.getInstance().resetSelection();
                return false;
            }
            if (!o.endsWith(String.valueOf('\r'))) {
                return this._search.search(o.substring(1));
            }
            this.executePostCommand();
            this._searchFinished = true;
        }
        return false;
    }

    private void executePostCommand() {
        if (this._postCommand != null) {
            this._postCommand.execute();
        }
    }

    public boolean searchFinished() {
        return this._searchFinished;
    }
}

