/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands.search;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import viPlugin.TextModificator;
import viPlugin.commands.search.ISearch;

public abstract class Search
implements ISearch {
    public IDocument _doc;
    public ITextSelection _selection;
    public TextModificator _tm;
    public String _lastSearch = "";
    public static final int NEW = 0;
    public static final int NEXT = 1;
    public static final int PREVIOUS = 2;

    public boolean searchNext() throws Exception {
        if (this._lastSearch != null) {
            return this.search(this._lastSearch, 1);
        }
        return false;
    }

    public boolean searchPrevious() throws Exception {
        if (this._lastSearch != null) {
            return this.search(this._lastSearch, 2);
        }
        return false;
    }

    public boolean search(String str) throws Exception {
        this._lastSearch = str;
        return this.search(str, 0);
    }

    public void searchCurrentWord() throws Exception {
        this._tm = TextModificator.getInstance();
        this._doc = this._tm.getDocument();
        this._selection = this._tm.getSelection();
        String text = this._doc.get();
        int cursorPos = this._selection.getOffset();
        cursorPos = this.skipToken(text, cursorPos);
        String word = text.substring(this.getPreviousDelimiter(text, cursorPos) + 1, this.getNextDelimiter(text, cursorPos));
        this.search("\\b" + word + "\\b", 1);
    }

    public void searchCurrentWordBackwards() throws Exception {
        this._tm = TextModificator.getInstance();
        this._doc = this._tm.getDocument();
        String text = this._doc.get();
        this._selection = this._tm.getSelection();
        int cursorPos = this._selection.getOffset();
        cursorPos = this.skipToken(text, cursorPos);
        String word = text.substring(this.getPreviousDelimiter(text, cursorPos) + 1, this.getNextDelimiter(text, cursorPos));
        this.search("\\b" + word + "\\b", 2);
    }

    public int getPreviousDelimiter(String text, int cursorPos) {
        int pos = cursorPos;
        int i = cursorPos - 1;
        while (i > 0) {
            if (!this.isWordCharacter(text.charAt(i))) {
                pos = i;
                break;
            }
            --i;
        }
        return pos;
    }

    public int getNextDelimiter(String text, int cursorPos) {
        int pos = cursorPos;
        int i = cursorPos + 1;
        while (i < text.length()) {
            if (!this.isWordCharacter(text.charAt(i))) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }

    public int skipToken(String text, int cursorPos) {
        int pos = cursorPos;
        int i = cursorPos;
        while (i < text.length()) {
            if (this.isWordCharacter(text.charAt(i))) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }

    public int skipTokenBackwards(String text, int cursorPos) {
        int pos = cursorPos;
        int i = cursorPos - 1;
        while (i > 0) {
            if (this.isWordCharacter(text.charAt(i))) {
                pos = i;
                break;
            }
            --i;
        }
        return pos;
    }

    public boolean isWordCharacter(char ch) {
        boolean isPunctuation;
        boolean bl = isPunctuation = Character.getType(ch) == 23;
        return Character.isLetterOrDigit(ch) || isPunctuation;
    }

    public abstract boolean search(String var1, int var2) throws Exception;
}

