/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.Shell;
import viPlugin.TextModificator;
import viPlugin.ViPluginPlugin;
import viPlugin.commands.search.Search;
import viPlugin.preferences.ViPreferenceService;

public class RegExSearch
extends Search {
    public static boolean isSupported(boolean showInformation) {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.4") || version.startsWith("1.5")) {
            return true;
        }
        if (showInformation) {
            MessageDialog.openInformation((Shell)TextModificator.getInstance().getTextEditor().getSite().getWorkbenchWindow().getShell(), (String)"Upgrade your java installation", (String)"Only supported with Java 1.4 or higher!");
        }
        return false;
    }

    public boolean search(String regex, int mode) throws Exception {
        try {
            if (regex == null) {
                throw new Exception("Got an empty string for searching!");
            }
            this._tm = TextModificator.getInstance();
            this._doc = this._tm.getDocument();
            this._selection = this._tm.getSelection();
            this._lastSearch = regex;
            String text = this._doc.get();
            int cursorPos = this._selection.getOffset();
            if (mode == 1) {
                ++cursorPos;
            }
            int cursor = -1;
            String foundStr = "";
            if (mode == 0 || mode == 1) {
                Pattern pat = Pattern.compile(regex, this.getFlags());
                Matcher matcher = pat.matcher(text);
                if (matcher.find(cursorPos) || matcher.find()) {
                    cursor = matcher.start();
                    foundStr = matcher.group();
                }
            } else {
                Pattern pat = Pattern.compile(regex, this.getFlags());
                Matcher matcher = pat.matcher(text);
                while (matcher.find()) {
                    int newCursor = matcher.start();
                    String newFoundStr = matcher.group();
                    if (newCursor >= cursorPos) break;
                    cursor = newCursor;
                    foundStr = newFoundStr;
                }
                if (cursor == -1) {
                    while (matcher.find()) {
                        cursor = matcher.start();
                        foundStr = matcher.group();
                    }
                }
            }
            if (cursor != -1) {
                this._tm.setCaretPosition(cursor);
                this._tm.setVisualSelection(cursor, foundStr.length());
            }
            return foundStr.length() > 0;
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return false;
    }

    private int getFlags() {
        if (ViPluginPlugin.getDefault() != null) {
            boolean ignoreCase = ViPreferenceService.getInstance().getBoolean("ignorecase");
            int flags = 8;
            if (ignoreCase) {
                flags |= 2;
            }
            return flags;
        }
        return 0;
    }
}

