/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import viPlugin.TextModificator;
import viPlugin.commands.Command;

public class ShiftSelection
extends Command {
    private TextModificator _tm = TextModificator.getInstance();
    private IDocument _doc = this._tm.getDocument();
    private ITextSelection _selection = this._tm.getSelection();
    private int _startLinePos = this._selection.getStartLine();
    private int _endLinePos = Math.max(this._startLinePos, this._endLinePos);
    private int _counter;
    private int _direction;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;

    public ShiftSelection(int counter, int direction) {
        if (this._selection.getLength() == 0) {
            this._counter = 1;
            this._endLinePos += counter - 1;
            this._endLinePos = Math.min(this._doc.getNumberOfLines() - 1, this._endLinePos);
        } else {
            this._counter = counter;
        }
        this._direction = direction;
    }

    public void execute() {
        try {
            StringBuffer shiftedBuffer = new StringBuffer();
            int i = this._startLinePos;
            while (i <= this._endLinePos) {
                this.shiftLine(i, this._counter, this._direction, shiftedBuffer);
                ++i;
            }
            IRegion startLine = this._doc.getLineInformation(this._startLinePos);
            IRegion endLine = this._doc.getLineInformation(this._endLinePos);
            int startPos = startLine.getOffset();
            int selectionLength = endLine.getOffset() + endLine.getLength() - startPos;
            String endLineDelimiter = this._doc.getLineDelimiter(this._endLinePos);
            if (endLineDelimiter != null) {
                selectionLength += endLineDelimiter.length();
            }
            this._doc.replace(startPos, selectionLength, "" + shiftedBuffer);
            int newPos = startPos;
            newPos += this._tm.getFirstVisibleCharacter(this._doc.get(newPos, startLine.getLength()));
            this._tm.setCaretPosition(newPos);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void shiftLine(int linePos, int c, int direction, StringBuffer shiftedBuffer) {
        try {
            IRegion line = this._doc.getLineInformation(linePos);
            StringBuffer text = new StringBuffer(this._doc.get(line.getOffset(), line.getLength()));
            int i = 0;
            while (i < c) {
                if (direction == 0) {
                    if (text.length() <= 0 || text.charAt(0) != '\t') break;
                    text.deleteCharAt(0);
                } else {
                    text.insert(0, '\t');
                }
                ++i;
            }
            shiftedBuffer.append("" + text);
            String lineDelimiter = this._doc.getLineDelimiter(linePos);
            if (lineDelimiter != null) {
                shiftedBuffer.append(lineDelimiter);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean saveUndo() {
        return true;
    }

    public void undo() {
        this.invertDirection();
        this.execute();
        this.invertDirection();
    }

    private int invertDirection() {
        this._direction = this._direction == 0 ? 1 : 0;
        return this._direction;
    }
}

