/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import viPlugin.TextModificator;
import viPlugin.commands.Command;
import viPlugin.commands.search.ISearch;
import viPlugin.commands.search.RegExSearch;
import viPlugin.commands.search.SearchDelegate;
import viPlugin.commands.search.SimpleSearch;

public class ReplaceString
extends Command {
    private String _match;
    private String _replace;
    private String _undoText;
    private int _pos;
    private int _counter;
    private int _startingLine = -1;
    private int _startingOffset = -1;
    private boolean _global;
    private TextModificator _tm;
    private IDocument _doc;
    private ITextSelection _selection;
    private SearchDelegate _searchDelegate;
    private ISearch _search;

    public ReplaceString(String command) {
        if (command == null) {
            throw new IllegalArgumentException();
        }
        if (!command.startsWith("%s/")) {
            throw new IllegalArgumentException();
        }
        if ((command = command.substring(3)).endsWith("/g")) {
            command = command.substring(0, command.length() - 2);
            this._global = true;
        } else if (command.endsWith("/")) {
            command = command.substring(0, command.length() - 1);
        }
        boolean foundSlash = false;
        boolean nextIsEscaped = false;
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < command.length()) {
            switch (command.charAt(i)) {
                case '\\': {
                    boolean bl = nextIsEscaped = !nextIsEscaped;
                    if (foundSlash) break;
                    sb.append(command.charAt(i));
                    break;
                }
                case '/': {
                    if (!nextIsEscaped) {
                        foundSlash = true;
                        this._match = sb.toString();
                        sb = new StringBuffer("");
                    } else {
                        sb.append(command.charAt(i));
                    }
                    nextIsEscaped = false;
                    break;
                }
                default: {
                    nextIsEscaped = false;
                    sb.append(command.charAt(i));
                }
            }
            ++i;
        }
        this._match = this._match.startsWith("/") ? this._match : "/" + this._match;
        this._replace = sb.toString();
        this._tm = TextModificator.getInstance();
        this._doc = this._tm.getDocument();
        this._search = RegExSearch.isSupported(true) ? new RegExSearch() : new SimpleSearch();
    }

    public void execute() {
        try {
            boolean searching = true;
            boolean isStart = true;
            boolean firstSearch = true;
            this._counter = 0;
            this._searchDelegate = new SearchDelegate(this._search);
            if (this._searchDelegate.search(this._match)) {
                do {
                    boolean bl = firstSearch = this._startingLine == -1 && this._startingOffset == -1;
                    if (firstSearch) {
                        this._startingLine = this._tm.getLinePos();
                        this._startingOffset = this._tm.getCaretPosition();
                    }
                    ++this._counter;
                    this._selection = this._tm.getSelection();
                    this._pos = this._selection.getOffset();
                    this._undoText = this._selection.getText();
                    this._doc.replace(this._pos, this._match.length() - 1, this._replace);
                    searching = this._global && this._search.searchNext() && this._search.searchNext();
                    boolean bl2 = isStart = this._global && (this._startingLine != this._tm.getLinePos() || this._startingOffset != this._tm.getCaretPosition() || firstSearch);
                } while (this._global && searching && isStart);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNumberReplaced() {
        return this._counter;
    }

    public void undo() {
        try {
            this._doc.replace(this._pos, this._undoText.length(), this._undoText);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean saveUndo() {
        return true;
    }
}

