/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import viPlugin.TextModificator;
import viPlugin.commands.Command;
import viPlugin.commands.InsertStringBelow;

public class PasteBelow
extends Command {
    private String insertText;
    private int pos;
    private int cursorPos;
    private TextModificator tm = TextModificator.getInstance();
    private IDocument doc = this.tm.getDocument();
    private boolean fullLines;
    private InsertStringBelow insertStringBelow;

    public PasteBelow() {
        this.insertText = this.tm.getYankBuffer().getBuffer("<default>").getText();
        this.fullLines = this.tm.getYankBuffer().getBuffer("<default>").getFullLines();
        this.cursorPos = this.tm.getCaretPosition();
    }

    public void execute() {
        try {
            if (!this.fullLines) {
                int addPos = 1;
                IRegion line = this.tm.getLine();
                int endOfLinePos = line.getOffset() + line.getLength();
                if (this.cursorPos == endOfLinePos) {
                    addPos = 0;
                }
                this.pos = this.cursorPos + addPos;
                this.doc.replace(this.cursorPos + addPos, 0, this.insertText);
            } else {
                this.insertStringBelow = new InsertStringBelow(this.insertText);
                this.insertStringBelow.execute();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean saveUndo() {
        return false;
    }

    public void undo() {
        try {
            if (!this.fullLines) {
                this.doc.replace(this.pos, this.insertText.length(), "");
            } else {
                this.insertStringBelow.undo();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

