/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands;

import viPlugin.TextModificator;
import viPlugin.commands.Command;
import viPlugin.commands.search.ISearch;
import viPlugin.commands.search.RegExSearch;

public class MatchBrace
extends Command {
    private ISearch _search = null;
    private String _searchString = "[{}\\(\\)\\[\\]<>]";
    private String _nString = "";
    private String _fString = "";
    private boolean _forward = false;
    private TextModificator _tm = null;

    public MatchBrace() {
        if (RegExSearch.isSupported(true)) {
            this._search = new RegExSearch();
            this._tm = TextModificator.getInstance();
        }
    }

    public void execute() {
        if (this._search == null) {
            return;
        }
        try {
            String selection = this._tm.getSelection().getText();
            this.setSearchParameters(selection);
            if (this._fString.length() == 0) {
                this._search.search(this._searchString);
            } else if (this._forward) {
                this.getNextBrace();
            } else {
                this.getPreviousBrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getNextBrace() throws Exception {
        int stack = 1;
        boolean found = false;
        this._search.search(this._searchString);
        while (!found && this._search.searchNext()) {
            String selection = this._tm.getSelection().getText();
            if (selection.equals(this._nString)) {
                ++stack;
                continue;
            }
            if (!selection.equals(this._fString.substring(1)) || --stack != 0) continue;
            found = true;
        }
    }

    private void getPreviousBrace() throws Exception {
        int stack = 1;
        boolean found = false;
        this._search.search(this._searchString);
        while (!found && this._search.searchPrevious()) {
            String selection = this._tm.getSelection().getText();
            if (selection.equals(this._nString)) {
                ++stack;
                continue;
            }
            if (!selection.equals(this._fString.substring(1)) || --stack != 0) continue;
            found = true;
        }
    }

    private void setSearchParameters(String select) {
        if (select == null || select.length() != 1) {
            this._searchString = "[\\[\\]{}()<>]";
            this._forward = true;
            return;
        }
        switch (select.charAt(0)) {
            case '{': {
                this._searchString = "[{}]";
                this._forward = true;
                this._fString = "\\}";
                this._nString = "{";
                break;
            }
            case '}': {
                this._searchString = "[{}]";
                this._forward = false;
                this._fString = "\\{";
                this._nString = "}";
                break;
            }
            case '(': {
                this._searchString = "[\\)\\(]";
                this._forward = true;
                this._fString = "\\)";
                this._nString = "(";
                break;
            }
            case ')': {
                this._searchString = "[\\)\\(]";
                this._forward = false;
                this._fString = "\\(";
                this._nString = ")";
                break;
            }
            case '[': {
                this._searchString = "[\\[\\]]";
                this._forward = true;
                this._fString = "\\]";
                this._nString = "[";
                break;
            }
            case ']': {
                this._searchString = "[\\[\\]]";
                this._forward = false;
                this._fString = "\\[";
                this._nString = "]";
                break;
            }
            case '<': {
                this._searchString = "[<>]";
                this._forward = true;
                this._fString = "\\>";
                this._nString = "<";
                break;
            }
            case '>': {
                this._searchString = "[<>]";
                this._forward = false;
                this._fString = "\\<";
                this._nString = ">";
                break;
            }
            default: {
                this._searchString = "[{}()\\[\\]<>]";
                this._forward = true;
            }
        }
    }
}

