/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import viPlugin.TextModificator;
import viPlugin.commands.Command;

public class InsertStringBelow
extends Command {
    private String insertText;
    private String undoText;
    private int pos;
    private TextModificator tm;
    private IDocument doc;

    public InsertStringBelow(String text) {
        this.insertText = text;
        this.tm = TextModificator.getInstance();
        this.doc = this.tm.getDocument();
    }

    public void execute() {
        this.undoText = this.insertText;
        try {
            int smartPos;
            IRegion line = this.tm.getLine();
            String delim = this.tm.getDelimiter();
            if (this.undoText.endsWith(delim)) {
                this.undoText = this.undoText.substring(0, this.undoText.length() - delim.length());
            }
            String whiteSpace = "";
            if (this.undoText.length() == 0 && (smartPos = this.tm.getFirstVisibleCharacter(this.doc.get(line.getOffset(), line.getLength()))) != -1) {
                whiteSpace = this.doc.get(line.getOffset(), smartPos);
            }
            this.pos = line.getOffset() + line.getLength();
            this.undoText = String.valueOf(delim) + whiteSpace + this.undoText;
            this.doc.replace(this.pos, 0, this.undoText);
            IRegion newLine = this.doc.getLineInformation(this.tm.getLinePos() + 1);
            this.tm.setCaretPosition(newLine.getOffset() + newLine.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean saveUndo() {
        return false;
    }

    public void undo() {
        try {
            this.doc.replace(this.pos, this.undoText.length(), "");
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

