/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import viPlugin.TextModificator;
import viPlugin.commands.Command;

public class InsertStringAbove
extends Command {
    private String insertText;
    private String undoText;
    private int pos;
    private TextModificator tm;
    private IDocument doc;

    public InsertStringAbove(String text) {
        this.insertText = text;
        this.tm = TextModificator.getInstance();
        this.doc = this.tm.getDocument();
    }

    public void execute() {
        try {
            int smartPos;
            IRegion line = this.tm.getLine();
            String delim = this.tm.getDelimiter();
            if (this.insertText.endsWith(delim)) {
                delim = "";
            }
            String whiteSpace = "";
            if (this.insertText.length() == 0 && (smartPos = this.tm.getFirstVisibleCharacter(this.doc.get(line.getOffset(), line.getLength()))) != -1) {
                whiteSpace = this.doc.get(line.getOffset(), smartPos);
            }
            this.pos = line.getOffset();
            this.undoText = String.valueOf(whiteSpace) + delim + this.insertText;
            this.doc.replace(this.pos, 0, this.undoText);
            IRegion newLine = this.doc.getLineInformationOfOffset(this.pos);
            this.tm.setCaretPosition(newLine.getOffset() + newLine.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            this.doc.replace(this.pos, this.undoText.length(), "");
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean saveUndo() {
        return true;
    }
}

