/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import viPlugin.TextModificator;
import viPlugin.commands.Command;

public class DeleteSelection
extends Command {
    private boolean includeDelimiter;
    private String text;
    private int pos;
    private TextModificator tm;
    private IDocument doc;
    private ITextSelection selection;
    private boolean deleteLastDelimiter;
    private boolean fullLines;

    public DeleteSelection(boolean includeDelimiter) {
        this.includeDelimiter = includeDelimiter;
        this.tm = TextModificator.getInstance();
        this.doc = this.tm.getDocument();
        this.deleteLastDelimiter = this.tm.getDeleteLastDelimiter();
    }

    public void execute() {
        this.selection = this.tm.getSelection();
        this.fullLines = this.tm.getYankBuffer().getBuffer("<default>").getFullLines();
        this.text = this.tm.getYankBuffer().getBuffer("<default>").getText();
        try {
            int delim = 0;
            int includeLastDelim = 0;
            if (this.deleteLastDelimiter) {
                delim = this.tm.getDelimiter().length();
            }
            if (!this.includeDelimiter && this.selection.getText().endsWith(this.tm.getDelimiter())) {
                includeLastDelim = this.tm.getDelimiter().length();
            }
            this.doc.replace(this.selection.getOffset() - delim, this.selection.getLength() + delim - includeLastDelim, "");
            if (this.fullLines) {
                int linePos = this.doc.getLineOfOffset(this.selection.getOffset() - delim);
                this.tm.cursorToLine(linePos, true);
            }
            this.tm.setDeleteLastDelimiter(false);
            this.pos = this.selection.getOffset() - delim;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            this.doc.replace(this.pos, 0, this.text);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean saveUndo() {
        return true;
    }
}

