/*
 * Decompiled with CFR 0.152.
 */
package viPlugin.commands;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import viPlugin.TextModificator;

public class BookMark {
    public static void add(String name) {
        try {
            IMarker marker = BookMark.getMarker(name, true);
            marker.setAttribute("lineNumber", TextModificator.getInstance().getLinePos() + 1);
            marker.setAttribute("message", (Object)name);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void goTo(String name) {
        IMarker marker = BookMark.getMarker(name, false);
        if (marker != null) {
            int linepos = marker.getAttribute("lineNumber", -1);
            TextModificator.getInstance().cursorToLine(linepos - 1, true);
        }
    }

    private static IMarker getMarker(String name, boolean create) {
        TextModificator tm = TextModificator.getInstance();
        IEditorInput editorInput = tm.getTextEditor().getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
        IFile file = fileEditorInput.getFile();
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.core.resources.bookmark", true, 2);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].getAttribute("message", "--").compareTo(name) == 0) {
                    return markers[i];
                }
                ++i;
            }
            if (create) {
                return file.createMarker("org.eclipse.core.resources.bookmark");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

