/*
 * Decompiled with CFR 0.152.
 */
package viPlugin;

import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Shell;
import viPlugin.ViLayer;

public class ViVerifyKeyListener
implements VerifyKeyListener {
    private final ViLayer _layer;
    public static final char ENTER = '\r';
    public static final String ENTER_STRING = String.valueOf('\r');

    ViVerifyKeyListener(ViLayer layer) {
        this._layer = layer;
    }

    public void verifyKey(VerifyEvent e) {
        if (e.character == '\u001b' && (this._layer.isInInsertMode() || this._layer.isInVisualMode())) {
            Shell shell;
            if (e.display != null && (shell = e.display.getActiveShell()) != null) {
                shell.setImeInputMode(0);
            }
            e.doit = false;
            if (this._layer.isInInsertMode()) {
                this._layer.switchToCommandMode();
            } else if (this._layer.isInVisualMode()) {
                this._layer.leaveVisualMode();
            }
        } else if (this._layer.isInCommandMode() || this._layer.isInVisualMode()) {
            this.inCommandMode(e);
        }
        if (!e.doit) {
            this._layer.setStatusLine();
        }
    }

    private void inCommandMode(VerifyEvent e) {
        switch (e.character) {
            case '\u0000': {
                if (e.keyCode == 0x1000002 && e.stateMask == 0) {
                    this._layer.commandBuffer.append("<CD>");
                    this._layer.commandBuffer.eval();
                    e.doit = false;
                    break;
                }
                if (e.keyCode == 0x1000001 && e.stateMask == 0) {
                    this._layer.commandBuffer.append("<CU>");
                    this._layer.commandBuffer.eval();
                    e.doit = false;
                    break;
                }
                if (e.keyCode == 0x1000003 && e.stateMask == 0) {
                    this._layer.commandBuffer.append("<CL>");
                    this._layer.commandBuffer.eval();
                    e.doit = false;
                    break;
                }
                if (e.keyCode == 0x1000004 && e.stateMask == 0) {
                    this._layer.commandBuffer.append("<CR>");
                    this._layer.commandBuffer.eval();
                    e.doit = false;
                    break;
                }
                e.doit = true;
                break;
            }
            case '\b': {
                this._layer.commandBuffer.backspace();
                this._layer.commandBuffer.eval();
                e.doit = false;
                break;
            }
            case '\u007f': {
                this._layer.commandBuffer.append("x");
                this._layer.commandBuffer.eval();
                e.doit = false;
                break;
            }
            case '\r': {
                if (e.display != null) {
                    e.display.getActiveShell().setImeInputMode(0);
                }
                this._layer.commandBuffer.append(e.character);
                this._layer.commandBuffer.eval();
                e.doit = false;
                break;
            }
            case 'U': {
                if (this._layer.commandBuffer.getCommand().startsWith(":") || this._layer.commandBuffer.getCommand().startsWith("/")) {
                    this._layer.commandBuffer.append(e.character);
                } else {
                    this._layer.commandBuffer.append("<REDO>");
                }
                this._layer.commandBuffer.eval();
                e.doit = false;
                break;
            }
            case 'Q': {
                if (this._layer.commandBuffer.getCommand().startsWith(":") || this._layer.commandBuffer.getCommand().startsWith("/")) {
                    this._layer.commandBuffer.append(e.character);
                } else {
                    this._layer.commandBuffer.append("<PU>");
                }
                this._layer.commandBuffer.eval();
                e.doit = false;
                break;
            }
            case 'q': {
                if (this._layer.commandBuffer.getCommand().startsWith(":") || this._layer.commandBuffer.getCommand().startsWith("/")) {
                    this._layer.commandBuffer.append(e.character);
                } else {
                    this._layer.commandBuffer.append("<PD>");
                }
                this._layer.commandBuffer.eval();
                e.doit = false;
                break;
            }
            default: {
                this._layer.commandBuffer.append(e.character);
                this._layer.commandBuffer.eval();
                e.doit = false;
            }
        }
    }
}

