/*
 * Decompiled with CFR 0.152.
 */
package viPlugin;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import viPlugin.TextModificator;
import viPlugin.ViLayer;

public class ViLayerFactory {
    private static Map viLayers = new HashMap();
    private IWorkbenchWindow window;
    private static ViLayerFactory viLayerFactory;

    public static void init(IWorkbenchWindow window) {
        if (viLayerFactory == null) {
            viLayerFactory = new ViLayerFactory();
            ViLayerFactory.viLayerFactory.window = window;
        }
    }

    public static ViLayerFactory getInstance() {
        if (viLayerFactory == null) {
            throw new NullPointerException("ViLayerFactory.init() must be called first.");
        }
        return viLayerFactory;
    }

    public void activateLayer(ITextEditor textEditor) {
        String currLayerId = this.getLayerId(textEditor);
        ViLayer currViLayer = this.getLayerById(currLayerId);
        if (currViLayer == null) {
            currViLayer = new ViLayer(textEditor);
            viLayers.put(currLayerId, currViLayer);
        } else {
            TextModificator.activateInstance(currViLayer.getTextModificator());
        }
    }

    public void unLoadAllLayers() {
        Iterator iter = viLayers.values().iterator();
        while (iter.hasNext()) {
            ViLayer viLayer = (ViLayer)iter.next();
            viLayer.switchToInsertMode();
            viLayer.unLoad();
            viLayers = new HashMap();
        }
    }

    public void unLoadCurrentLayer(boolean switchToInsertMode) {
        ViLayer viLayer;
        ITextEditor currEditor = this.getCurrTextEditor();
        if (currEditor != null && (viLayer = this.getLayerById(this.getLayerId(currEditor))) != null) {
            if (switchToInsertMode) {
                viLayer.switchToInsertMode();
            }
            viLayer.unLoad();
        }
    }

    public void removeViLayer(ITextEditor editor) {
        String layerId;
        ViLayer viLayer;
        if (editor != null && (viLayer = this.getLayerById(layerId = this.getLayerId(editor))) != null) {
            viLayer.unLoad();
            viLayers.remove(layerId);
        }
    }

    private ITextEditor getCurrTextEditor() {
        IEditorPart editor = this.window.getActivePage().getActiveEditor();
        if (editor instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        return null;
    }

    private ViLayer getLayerById(String currLayerId) {
        return (ViLayer)viLayers.get(currLayerId);
    }

    private String getLayerId(ITextEditor textEditor) {
        return textEditor.getEditorInput().getToolTipText();
    }
}

