/*
 * Decompiled with CFR 0.152.
 */
package viPlugin;

import java.lang.reflect.Method;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;
import viPlugin.CommandBuffer;
import viPlugin.ILayerInterface;
import viPlugin.TextModificator;
import viPlugin.ViMode;
import viPlugin.ViVerifyKeyListener;
import viPlugin.preferences.ViPreferenceService;

public class ViLayer
implements ILayerInterface {
    public CommandBuffer commandBuffer;
    public ViMode mode = ViMode.COMMAND_MODE;
    private IStatusLineManager slm;
    private StyledText _textWidget;
    private ITextViewer _textViewer;
    private ViVerifyKeyListener _keyListener;
    private Caret _originalCaret;
    private Caret _vimCaret;
    private static final int CARET_THIN = 1;
    private TextModificator textModificator;
    static /* synthetic */ Class class$0;

    public ViLayer(ITextEditor textEditor) {
        DefaultUndoManager undoManager = new DefaultUndoManager(100);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.AbstractTextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method me = clazz.getDeclaredMethod("getSourceViewer", null);
            me.setAccessible(true);
            Object viewer = me.invoke((Object)textEditor, null);
            this._keyListener = new ViVerifyKeyListener(this);
            ((ITextViewerExtension)viewer).prependVerifyKeyListener((VerifyKeyListener)this._keyListener);
            this._textViewer = (ITextViewer)viewer;
            this._textViewer.setUndoManager((IUndoManager)undoManager);
            undoManager.connect(this._textViewer);
            this._textWidget = this._textViewer.getTextWidget();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        IEditorSite editorSite = textEditor.getEditorSite();
        this.slm = editorSite.getActionBars().getStatusLineManager();
        try {
            this.textModificator = new TextModificator(textEditor, this._textViewer);
            TextModificator.activateInstance(this.textModificator);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._originalCaret = this._textWidget.getCaret();
        this._vimCaret = new Caret(this._originalCaret.getParent(), this._originalCaret.getStyle());
        this._vimCaret.setImage(null);
        this._textWidget.setCaret(this._vimCaret);
        this.commandBuffer = new CommandBuffer(this);
        this.commandBuffer.setUndoManager((IUndoManager)undoManager);
        this.switchToCommandMode();
        this.setStatusLine();
    }

    void setStatusLine() {
        String message = new String();
        message = this.mode == ViMode.COMMAND_MODE ? "CommandMode: CommandBuffer = " + this.commandBuffer.getCommand() : (this.mode == ViMode.INSERT_MODE ? "InsertMode" : (this.mode == ViMode.VISUAL_MODE ? "VisualMode" : "MODE NOT SUPPORTED - SOMETHING IS VERY WRONG!"));
        this.slm.setMessage(message);
    }

    public void switchToCommandMode() {
        this.mode = ViMode.COMMAND_MODE;
        this.commandBuffer.endCompoundChange();
        this.commandBuffer.clear();
        this.setStatusLine();
        this.setCaretThick();
        this.resetSelection();
    }

    public void switchToInsertMode() {
        this.mode = ViMode.INSERT_MODE;
        this.setStatusLine();
        this.commandBuffer.clear();
        this.commandBuffer.beginCompoundChange();
        this.setCaretThin();
    }

    public void switchToVisualMode() {
        this.mode = ViMode.VISUAL_MODE;
        TextModificator.getInstance().activateVisualMode();
        this.setStatusLine();
        this.commandBuffer.clear();
        this.commandBuffer.beginCompoundChange();
        this.setCaretThick();
    }

    public void leaveVisualMode() {
        this.switchToCommandMode();
        TextModificator.getInstance().deactivateVisualMode();
    }

    public void unLoad() {
        this.commandBuffer.clear();
        ((ITextViewerExtension)this._textViewer).removeVerifyKeyListener((VerifyKeyListener)this._keyListener);
        this.setStatusLine();
        if (!this._textWidget.isDisposed()) {
            this._textWidget.setCaret(this._originalCaret);
        }
    }

    private void setCaretWidth(int width) {
        this._vimCaret.setSize(width, this._vimCaret.getSize().y);
    }

    private void setCaretThin() {
        this.setCaretWidth(1);
    }

    private void setCaretThick() {
        boolean vimStyleCursor = ViPreferenceService.getInstance().getBoolean("vimcursor");
        if (vimStyleCursor) {
            GC gc = new GC((Drawable)this._textWidget);
            this.setCaretWidth(gc.getFontMetrics().getAverageCharWidth());
            gc.dispose();
        }
    }

    private void resetSelection() {
        TextModificator.getInstance().setVisualSelection(this._textWidget.getCaretOffset(), 0);
    }

    public TextModificator getTextModificator() {
        return this.textModificator;
    }

    public boolean isInInsertMode() {
        return this.mode == ViMode.INSERT_MODE;
    }

    public boolean isInVisualMode() {
        return this.mode == ViMode.VISUAL_MODE;
    }

    public boolean isInCommandMode() {
        return this.mode == ViMode.COMMAND_MODE;
    }

    public void switchVisualMode() {
        if (this.isInVisualMode()) {
            this.leaveVisualMode();
        } else {
            this.switchToVisualMode();
        }
    }
}

