/*
 * Decompiled with CFR 0.152.
 */
package viPlugin;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import viPlugin.YankBuffer;

public class TextModificator {
    private static TextModificator _currTextModificator;
    private ITextEditor _textEditor;
    private ITextViewer _textViewer;
    private IDocument _document;
    private YankBuffer _yankBuffer;
    private ITextSelection _visualSelection;
    private ITextSelection _internalSelection;
    private boolean _deleteLastDelimiter;
    private char _lastSearchCh;
    private boolean _doesSearchChBackward;
    private boolean _isSearchChInclusive;
    private boolean _isInVisualMode;
    private int _visualAnchor;
    private final char[] _wordEndings = new char[]{'.', '(', ')', ' ', '\t', '\n', ':', ';', '?', '+', '=', '>', '<', '*', '{', '}', '\"', '|', ',', '-', '_', '/', '@'};

    public TextModificator(ITextEditor textEditor, ITextViewer textViewer) {
        this._textEditor = textEditor;
        this._textViewer = textViewer;
        this._yankBuffer = new YankBuffer("<default>");
    }

    public static void activateInstance(TextModificator textModificator) {
        _currTextModificator = textModificator;
    }

    public static TextModificator getInstance() {
        return _currTextModificator;
    }

    public static void setEmptyInstance(IDocument doc) {
        TextModificator.activateInstance(new TextModificator(null, null));
        _currTextModificator.setDocument(doc);
        _currTextModificator.setSelection((ITextSelection)new TextSelection(doc, 0, 0));
    }

    public ITextEditor getTextEditor() {
        return this._textEditor;
    }

    public ITextSelection getSelection() {
        if (this._isInVisualMode) {
            return this._visualSelection;
        }
        return this._internalSelection;
    }

    public IDocument getDocument() {
        return this._document;
    }

    public YankBuffer getYankBuffer() {
        return this._yankBuffer;
    }

    public IRegion getLine() {
        try {
            return this._document.getLineInformation(this.getLinePos());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getLinePos() {
        try {
            return this._document.getLineOfOffset(this.getCaretPosition());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getDelimiter() {
        String delim;
        try {
            delim = this._document.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {
            delim = this._document.getLegalLineDelimiters()[0];
        }
        if (delim == null) {
            delim = this._document.getLegalLineDelimiters()[0];
        }
        return delim;
    }

    public String getLineDelimiter(int linePos) {
        String delim;
        try {
            delim = this._document.getLineDelimiter(linePos);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
        if (delim == null) {
            return "";
        }
        return delim;
    }

    public void setSelection(ITextSelection selection) {
        this._internalSelection = this._visualSelection = selection;
    }

    public void setVisualSelection(int start, int length) {
        this._internalSelection = this._visualSelection = new TextSelection(this._document, start, length);
        if (this._textEditor != null) {
            this._textEditor.getSelectionProvider().setSelection((ISelection)this._visualSelection);
        }
    }

    public void setInternalSelection(int start, int length) {
        this._internalSelection = new TextSelection(this._document, start, length);
    }

    public void setDocument(IDocument document) {
        this._document = document;
    }

    public void setCaretPosition(int pos) throws BadLocationException {
        if (this._isInVisualMode) {
            this.refreshVisualSelection(pos);
        } else {
            this.setInternalSelection(pos, 0);
            if (this._textViewer != null) {
                this._textViewer.getTextWidget().setCaretOffset(pos);
                this._textViewer.getTextWidget().showSelection();
            }
        }
    }

    public int getCaretPosition() {
        if (this._isInVisualMode && this._visualAnchor == this.getSelection().getOffset()) {
            return this._visualAnchor + this.getSelection().getLength();
        }
        return this.getSelection().getOffset();
    }

    private int getCursorInLinePosition() throws BadLocationException {
        int cursorInLinePos = this.getCaretPosition() - this.getLine().getOffset();
        return cursorInLinePos;
    }

    private int getPreviousWhiteSpace(String text, int startIndex) {
        int index = text.lastIndexOf(" ", startIndex - 1);
        if (index == -1) {
            index = 0;
        }
        return index;
    }

    private int getNextWhiteSpace(String text, int startIndex) {
        int index = text.indexOf(" ", startIndex + 1);
        if (index == -1) {
            index = text.length() - 1;
        }
        return index;
    }

    public int getNextNonBlankCharacter(String text, int from) {
        int i = from;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isWordEnding(char ch, boolean withSpace) {
        if (!withSpace && ch == ' ') {
            return false;
        }
        int i = 0;
        while (i < this._wordEndings.length) {
            if (this._wordEndings[i] == ch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getEndOfCurrentWord(String text, int startIndex) {
        int endIndex = text.length();
        int newStartIndex = startIndex;
        int i = startIndex + 1;
        while (i < endIndex && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        newStartIndex = i;
        int index = 0;
        i = 0;
        while (i < this._wordEndings.length) {
            index = text.indexOf(this._wordEndings[i], newStartIndex);
            if (index > 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        if (newStartIndex == endIndex) {
            i = startIndex + 2;
            while (i < text.length()) {
                if (!this.isWordEnding(text.charAt(i), false)) break;
                endIndex = i++;
            }
            return endIndex;
        }
        return endIndex - 1;
    }

    public int getNextWord(String text, int startIndex) {
        char c;
        int endIndex = text.length();
        int newStartIndex = startIndex;
        if (text == null) {
            return 0;
        }
        if (text.length() == 0) {
            return 0;
        }
        if (this.isWordEnding(text.charAt(startIndex), false)) {
            int i = startIndex + 1;
            while (i < text.length()) {
                if (!this.isWordEnding(text.charAt(i), false)) break;
                newStartIndex = i++;
            }
        }
        int index = 0;
        int i = 0;
        while (i < this._wordEndings.length) {
            index = text.indexOf(this._wordEndings[i], newStartIndex);
            if (index > 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        if (newStartIndex == endIndex) {
            i = newStartIndex + 1;
            while (i < text.length()) {
                c = text.charAt(i);
                if (this.isWordEnding(c, false) || Character.isLetter(c)) {
                    return i;
                }
                ++i;
            }
        }
        if (endIndex < text.length()) {
            if (text.charAt(endIndex) == ' ') {
                i = endIndex;
                while (i < text.length()) {
                    c = text.charAt(i);
                    if (this.isWordEnding(c, false) || Character.isLetter(c)) {
                        return i;
                    }
                    ++i;
                }
            }
        } else {
            --endIndex;
        }
        return endIndex;
    }

    public int getPreviousWord(String text, int startIndex) {
        int i = startIndex - 1;
        while (i >= 0) {
            if (this.getNextWord(text, i) < startIndex - 1) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int cursorLeft(int counter) {
        try {
            int start = this.getLine().getOffset();
            int newPosition = this.getCaretPosition() - counter;
            if (newPosition < start) {
                newPosition = start;
            }
            this.setCaretPosition(newPosition);
            return newPosition;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int cursorRight(int counter) {
        try {
            int end = this.getLine().getOffset() + this.getLine().getLength();
            int newPosition = this.getCaretPosition() + counter;
            if (newPosition > end) {
                newPosition = end;
            }
            this.setCaretPosition(newPosition);
            return newPosition;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int cursorToLine(int linenr, boolean toLineBegin) {
        try {
            linenr = Math.max(0, linenr);
            linenr = Math.min(linenr, this._document.getNumberOfLines() - 1);
            IRegion line = this._document.getLineInformation(linenr);
            if (toLineBegin) {
                this.setCaretPosition(line.getOffset());
                return this.getCaretPosition();
            }
            int cursorInLinePos = this.getCursorInLinePosition();
            if (line.getLength() < cursorInLinePos) {
                cursorInLinePos = line.getLength();
            }
            this.setCaretPosition(line.getOffset() + cursorInLinePos);
            return this.getCaretPosition();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int cursorWordBack(int cursor) {
        try {
            String text = this._document.get();
            int newCursor = this.getCaretPosition();
            int i = 0;
            while (i < cursor) {
                newCursor = this.getPreviousWord(text, newCursor);
                ++i;
            }
            this.setCaretPosition(newCursor + 1);
            return newCursor + 1;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int cursorToLineEnd() {
        try {
            IRegion line = this.getLine();
            this.setCaretPosition(line.getOffset() + line.getLength());
            return this.getCaretPosition();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void cursorToLineBegin() {
        this.cursorToLine(this.getLinePos(), true);
    }

    public int cursorWordEnd(int counter) {
        try {
            String text = this._document.get();
            int newCursor = this.getCaretPosition();
            int i = 0;
            while (i < counter) {
                newCursor = this.getEndOfCurrentWord(text, newCursor);
                ++i;
            }
            this.setCaretPosition(newCursor);
            return newCursor;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int cursorNextWhiteSpace(int counter) {
        try {
            String text = this._document.get();
            int newCursor = this.getCaretPosition();
            int i = 0;
            while (i < counter) {
                newCursor = this.getNextWhiteSpace(text, newCursor + 1);
                ++i;
            }
            this.setCaretPosition(newCursor + 1);
            return newCursor + 1;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int cursorToLineFirstNonBlank() {
        try {
            IRegion line = this._document.getLineInformation(this.getLinePos());
            if (line.getLength() == 0) {
                this.cursorToLine(this.getLinePos(), true);
            } else {
                this.setCaretPosition(this.getNextNonBlankCharacter(this._document.get(), line.getOffset()));
            }
            return this.getCaretPosition();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void replaceCharacters(String text) {
        try {
            if (text.length() > 0) {
                int i = 1;
                while (i < this.getSelection().getLength()) {
                    text = String.valueOf(text) + text.charAt(0);
                    ++i;
                }
            }
            this._document.replace(this.getSelection().getOffset(), this.getSelection().getLength(), text);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean selectCharacters(int nr) {
        int cursorPos = this.getCaretPosition();
        IRegion line = this.getLine();
        int offset = line.getOffset();
        int length = line.getLength();
        String delim = this.getLineDelimiter(this.getLinePos());
        if (delim != null && cursorPos == offset + length || cursorPos == this._document.getLength()) {
            return false;
        }
        if (nr + cursorPos > offset + length) {
            nr = offset + length - cursorPos;
        }
        this.setInternalSelection(cursorPos, nr);
        return true;
    }

    public boolean selectCharactersBackwards(int nr) {
        int cursorPos = this.getCaretPosition();
        IRegion line = this.getLine();
        int offset = line.getOffset();
        if (cursorPos == 0 || cursorPos == offset) {
            return false;
        }
        if (cursorPos - nr < offset) {
            nr = cursorPos - offset;
        }
        this.setInternalSelection(cursorPos - nr, nr);
        return true;
    }

    public int selectToCharacter(int counter, char ch, boolean inclusive) {
        String text;
        int pos = this.getCaretPosition();
        IRegion line = this.getLine();
        int offset = line.getOffset();
        int endLine = line.getLength();
        try {
            text = this._document.get(pos, offset + endLine - pos);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
        int i = 1;
        while (i < text.length()) {
            if (text.charAt(i) == ch && --counter == 0) {
                if (inclusive) {
                    ++i;
                }
                this.setInternalSelection(pos, i);
                return pos + i;
            }
            ++i;
        }
        return -1;
    }

    public int selectToCharacterBackward(int counter, char ch, boolean inclusive) {
        String text;
        int pos = this.getCaretPosition();
        IRegion line = this.getLine();
        int offset = line.getOffset();
        try {
            text = this._document.get(offset, pos - offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
        int i = text.length() - 1;
        while (i >= 0) {
            if (text.charAt(i) == ch && --counter == 0) {
                if (!inclusive) {
                    ++i;
                }
                this.setInternalSelection(pos - (text.length() - i), text.length() - i);
                return pos - (text.length() - i);
            }
            --i;
        }
        return -1;
    }

    public void selectWordsBack(int words) {
        int start;
        int end = start = this.getCaretPosition();
        String text = this._document.get();
        int i = 0;
        while (i < words) {
            end = this.getPreviousWhiteSpace(text, end + 1);
            ++i;
        }
        int length = end - start + 1;
        this.setInternalSelection(start, length);
    }

    public void selectNextWhiteSpace(int counter) {
        int start;
        int end = start = this.getCaretPosition();
        String text = this._document.get();
        int i = 0;
        while (i < counter) {
            end = this.getNextWhiteSpace(text, end + 1);
            ++i;
        }
        int length = end - start + 1;
        this.setInternalSelection(start, length);
    }

    public void removeDelimiter() {
        try {
            String delim = this.getLineDelimiter(this.getLinePos());
            if (delim != null) {
                this._document.replace(this.getLine().getOffset() + this.getLine().getLength(), delim.length(), "");
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public int getFirstVisibleCharacter(String string) {
        int i = 0;
        while (i < string.length()) {
            if (!Character.isWhitespace(string.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void searchCharacter(int c, char ch, boolean inclusive) {
        this._lastSearchCh = ch;
        this._doesSearchChBackward = false;
        this._isSearchChInclusive = inclusive;
        this.cursorToCharacter(c, ch, inclusive);
    }

    public void searchCharacterBackward(int c, char ch, boolean inclusive) {
        this._lastSearchCh = ch;
        this._doesSearchChBackward = true;
        this._isSearchChInclusive = inclusive;
        this.cursorToCharacterBackward(c, ch, inclusive);
    }

    public void searchToCharacterNext(int c) {
        if (this._lastSearchCh != '\u0000') {
            if (this._doesSearchChBackward) {
                this.cursorToCharacterBackward(c, this._lastSearchCh, this._isSearchChInclusive);
            } else {
                this.cursorToCharacter(c, this._lastSearchCh, this._isSearchChInclusive);
            }
        }
    }

    public void searchToCharacterNextBackward(int c) {
        if (this._lastSearchCh != '\u0000') {
            if (this._doesSearchChBackward) {
                this.cursorToCharacter(c, this._lastSearchCh, this._isSearchChInclusive);
            } else {
                this.cursorToCharacterBackward(c, this._lastSearchCh, this._isSearchChInclusive);
            }
        }
    }

    public void cursorToCharacter(int c, char ch, boolean inclusive) {
        try {
            int pos = this.selectToCharacter(c, ch, inclusive);
            if (pos != -1) {
                this.setCaretPosition(pos - 1);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void cursorToCharacterBackward(int c, char ch, boolean inclusive) {
        try {
            int pos = this.selectToCharacterBackward(c, ch, inclusive);
            if (pos != -1) {
                this.setCaretPosition(pos);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public ITextViewer getTextViewer() {
        return this._textViewer;
    }

    public void pageUp(int counter) {
        int lines = this._textViewer.getBottomIndex() - this._textViewer.getTopIndex();
        this.cursorToLine(this.getLinePos() - lines * counter - 1, true);
    }

    public void pageDown(int counter) {
        int lines = this._textViewer.getBottomIndex() - this._textViewer.getTopIndex();
        this.cursorToLine(this.getLinePos() + lines * counter + 1, true);
    }

    public void scrollUp(int counter) {
        int lines = this._textViewer.getBottomIndex() - this._textViewer.getTopIndex();
        this.cursorToLine(this.getLinePos() - (lines /= 2) * counter - 1, true);
    }

    public void scrollDown(int counter) {
        int lines = this._textViewer.getBottomIndex() - this._textViewer.getTopIndex();
        this.cursorToLine(this.getLinePos() + (lines /= 2) * counter + 1, true);
    }

    public void activateVisualMode() {
        this._visualAnchor = this.getCaretPosition();
        this._isInVisualMode = true;
    }

    public void deactivateVisualMode() {
        this._isInVisualMode = false;
    }

    void refreshVisualSelection(int newPosition) {
        this.setVisualSelection(this._visualAnchor < newPosition ? this._visualAnchor : newPosition, Math.abs(newPosition - this._visualAnchor));
    }

    public void resetSelection() {
        this.setVisualSelection(this.getCaretPosition(), 0);
    }

    public String getText(int offset, int length) {
        return new TextSelection(this._document, offset, length).getText();
    }

    public void setDeleteLastDelimiter(boolean deleteLastDelimiter) {
        this._deleteLastDelimiter = deleteLastDelimiter;
    }

    public boolean getDeleteLastDelimiter() {
        return this._deleteLastDelimiter;
    }

    public String getLineText() {
        IRegion line = this.getLine();
        return this.getText(line.getOffset(), line.getLength());
    }
}

