/*
 * Decompiled with CFR 0.152.
 */
package viPlugin;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import viPlugin.CommandHistory;
import viPlugin.CommandParser;
import viPlugin.TextModificator;
import viPlugin.ViLayer;
import viPlugin.ViVerifyKeyListener;
import viPlugin.commands.BookMark;
import viPlugin.commands.ChangeCaseSelection;
import viPlugin.commands.Command;
import viPlugin.commands.DeleteSelection;
import viPlugin.commands.ExtendSelectionToOffset;
import viPlugin.commands.GroupCommand;
import viPlugin.commands.InsertStringAbove;
import viPlugin.commands.InsertStringBelow;
import viPlugin.commands.LineJoin;
import viPlugin.commands.MatchBrace;
import viPlugin.commands.PasteAbove;
import viPlugin.commands.PasteBelow;
import viPlugin.commands.ReplaceString;
import viPlugin.commands.ShiftSelection;
import viPlugin.commands.SwitchToInsertModeCommand;
import viPlugin.commands.YankSelection;
import viPlugin.commands.delete.DeleteCommandFactory;
import viPlugin.commands.motion.MotionCommandFactory;
import viPlugin.commands.search.ISearch;
import viPlugin.commands.search.RegExSearch;
import viPlugin.commands.search.SearchDelegate;
import viPlugin.commands.search.SimpleSearch;
import viPlugin.commands.select.SelectLines;
import viPlugin.commands.select.SelectToLineBegin;
import viPlugin.commands.select.SelectToLineBeginNonBlank;
import viPlugin.commands.select.SelectToLineEnd;
import viPlugin.commands.select.SelectionCommandFactory;
import viPlugin.preferences.ViPreferenceService;

public class CommandBuffer {
    private String _cmdString;
    private String _prevCmdString;
    private TextModificator _tm = TextModificator.getInstance();
    private ViLayer _viLayer;
    private ISearch _search;
    private SearchDelegate _searchDelegate;
    private IUndoManager _undoManager;
    private CommandHistory _extendedCommandHistory;
    private CommandHistory _searchCommandHistory;

    public CommandBuffer(ViLayer viLayer) {
        this._viLayer = viLayer;
        this._cmdString = new String();
        this._extendedCommandHistory = new CommandHistory();
        this._searchCommandHistory = new CommandHistory();
        this._search = RegExSearch.isSupported(true) ? new RegExSearch() : new SimpleSearch();
    }

    public String getPreviousCommand() {
        return this._prevCmdString;
    }

    public String getCommand() {
        if (this._cmdString.equals("")) {
            return "Empty";
        }
        return this._cmdString;
    }

    public void append(char command) {
        this._cmdString = String.valueOf(this._cmdString) + command;
    }

    public void append(String command) {
        this._cmdString = String.valueOf(this._cmdString) + command;
    }

    public void backspace() {
        this._cmdString = this._cmdString.length() > 0 && (this._cmdString.startsWith("/") || this._cmdString.startsWith(":")) ? this._cmdString.substring(0, this._cmdString.length() - 1) : "h";
    }

    public void clear() {
        this._cmdString = "";
        this._searchDelegate = null;
    }

    public void eval() {
        try {
            CommandParser commandParser = new CommandParser();
            if (!commandParser.parse(this._cmdString)) {
                this.clear();
                return;
            }
            boolean uc = commandParser._useCounter;
            int c = commandParser._counter;
            String o = commandParser._operation;
            String m = commandParser._modifier;
            IDocument document = this._tm.getTextEditor().getDocumentProvider().getDocument((Object)this._tm.getTextEditor().getEditorInput());
            this._tm.setDocument(document);
            ITextSelection selection = (ITextSelection)this._tm.getTextEditor().getSelectionProvider().getSelection();
            this._tm.setSelection(selection);
            if (o.length() == 0) {
                return;
            }
            if (this._searchDelegate != null) {
                this._searchDelegate.search(o);
                if (this._searchDelegate.searchFinished()) {
                    this.clear();
                }
            } else if (o.equals("ZZ")) {
                o = "wq!";
                this.evalColonCommand(o);
            } else if (this.isColonCommandComplete(o)) {
                this.evalColonCommand(o.substring(1, o.length() - 1));
            } else if (o.startsWith(":") && o.endsWith("<CU>")) {
                this.clear();
                this.append(this._extendedCommandHistory.up());
            } else if (o.startsWith(":") && o.endsWith("<CD>")) {
                this.clear();
                this.append(this._extendedCommandHistory.down());
            } else if (!this.evalMotionCommand(o, c, uc)) {
                if (this.preprocessInsertModeCommand(o, c)) {
                    this._viLayer.switchToInsertMode();
                } else if (o.equals("v")) {
                    this._viLayer.switchVisualMode();
                } else {
                    if (this.evalSelectionCommands(o, c)) {
                        return;
                    }
                    if (o.startsWith("y") || o.startsWith("Y")) {
                        this.evalYankCommand(o, m, c);
                    } else if (this.isDeleteCommand(o)) {
                        this.evalDeleteCommand(o, m, c);
                    } else if (o.equals(".")) {
                        if (this._prevCmdString.length() != 0) {
                            this._cmdString = this._prevCmdString;
                            this.eval();
                        } else {
                            this.clear();
                        }
                    } else if (o.equals("/")) {
                        this._searchDelegate = new SearchDelegate(this._search);
                    } else if (o.equals("P")) {
                        this._prevCmdString = this._cmdString;
                        this.evalMultiple(new PasteAbove(), c);
                        this.clear();
                    } else if (o.equals("p")) {
                        this._prevCmdString = this._cmdString;
                        this.evalMultiple(new PasteBelow(), c);
                        this.clear();
                    } else if (o.equals("x")) {
                        this._prevCmdString = this._cmdString;
                        this.clear();
                        if (this._tm.selectCharacters(c)) {
                            YankSelection yankSelection = new YankSelection();
                            yankSelection.execute();
                            DeleteSelection deleteSelection = new DeleteSelection(true);
                            deleteSelection.execute();
                        }
                    } else if (o.equals("X")) {
                        this._prevCmdString = this._cmdString;
                        this.clear();
                        if (this._tm.selectCharactersBackwards(c)) {
                            YankSelection yankSelection = new YankSelection();
                            yankSelection.execute();
                            DeleteSelection deleteSelection = new DeleteSelection(true);
                            deleteSelection.execute();
                        }
                    } else if (o.startsWith("r") && o.length() > 1) {
                        this._prevCmdString = this._cmdString;
                        this._tm.selectCharacters(c);
                        this._tm.replaceCharacters(m);
                        this.clear();
                    } else if (o.equals("~")) {
                        this._prevCmdString = this._cmdString;
                        this._tm.selectCharacters(c);
                        ChangeCaseSelection command = new ChangeCaseSelection();
                        command.execute();
                        this.clear();
                    } else if (o.equals("<<")) {
                        this._prevCmdString = this._cmdString;
                        ShiftSelection shiftSelection = new ShiftSelection(c, 0);
                        shiftSelection.execute();
                        this.clear();
                    } else if (o.equals(">>")) {
                        this._prevCmdString = this._cmdString;
                        ShiftSelection shiftSelection = new ShiftSelection(c, 1);
                        shiftSelection.execute();
                        this.clear();
                    } else if (o.equals("J")) {
                        this._prevCmdString = this._cmdString;
                        LineJoin lineJoin = new LineJoin();
                        ((Command)lineJoin).execute();
                        this.clear();
                    } else if (o.startsWith("m") && m.length() == 1) {
                        BookMark.add(m);
                        this.clear();
                    } else if (o.startsWith("'") && m.length() == 1) {
                        BookMark.goTo(m);
                        this.clear();
                    } else if (o.equals("u")) {
                        this._undoManager.undo();
                        this.clear();
                    } else if (o.equals("<REDO>")) {
                        this._undoManager.redo();
                        this.clear();
                    } else if (o.charAt(o.length() - 1) == '\u001b') {
                        this.clear();
                    } else if (o.endsWith(String.valueOf('\r'))) {
                        this.clear();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isColonCommand(String o) {
        return o.startsWith(":");
    }

    private boolean isColonCommandComplete(String o) {
        return o.startsWith(":") && o.endsWith(ViVerifyKeyListener.ENTER_STRING);
    }

    private void evalMultiple(Command command, int counter) {
        int i = 0;
        while (i < counter) {
            command.execute();
            ++i;
        }
    }

    private boolean isDeleteCommand(String o) {
        return o.startsWith("d") || o.startsWith("D") || o.startsWith("c") || o.startsWith("S") || o.startsWith("C");
    }

    private boolean preprocessInsertModeCommand(String o, int c) {
        boolean isInsertCommand = true;
        if (!o.equals("i")) {
            if (o.equals("a")) {
                this._tm.cursorRight(1);
            } else if (o.equals("I")) {
                this._tm.cursorToLineFirstNonBlank();
            } else if (o.equals("A")) {
                this._tm.cursorToLineEnd();
            } else if (o.equals("s")) {
                this._tm.selectCharacters(c);
                DeleteSelection deleteSelection = new DeleteSelection(false);
                deleteSelection.execute();
            } else if (o.equals("o")) {
                InsertStringBelow insertStringBelow = new InsertStringBelow("");
                insertStringBelow.execute();
            } else if (o.equals("O")) {
                InsertStringAbove insertStringAbove = new InsertStringAbove("");
                insertStringAbove.execute();
            } else {
                isInsertCommand = false;
            }
        }
        return isInsertCommand;
    }

    private void evalDeleteCommand(String o, String m, int c) {
        boolean checkLastDelimiter = o.startsWith("d");
        Command delete = DeleteCommandFactory.createCommand(o, m, c);
        if (delete != null) {
            delete.execute();
        } else {
            SelectLines selectLines;
            if (m.equals("d") || o.equals("cc") || o.equals("S")) {
                selectLines = new SelectLines(c, 1, checkLastDelimiter);
                selectLines.execute();
            } else if (m.equals("<CD>") || m.equals("j")) {
                selectLines = new SelectLines(c + 1, 1, checkLastDelimiter);
                selectLines.execute();
            } else if (m.equals("<CU>") || m.equals("k")) {
                selectLines = new SelectLines(c, 0, checkLastDelimiter);
                selectLines.execute();
            } else if (m.equals("<CR>") || m.equals("h")) {
                this._tm.selectCharactersBackwards(c);
            } else if (m.equals("<CL>") || m.equals("l")) {
                this._tm.selectCharacters(c);
            } else if (m.equals("$") || o.equals("D") || o.equals("C")) {
                SelectToLineEnd selectToLineEnd = new SelectToLineEnd();
                selectToLineEnd.execute();
            } else if (m.equals("0")) {
                SelectToLineBegin selectToLineBegin = new SelectToLineBegin();
                selectToLineBegin.execute();
            } else if (m.equals("^")) {
                SelectToLineBeginNonBlank slctToLineBeginNB = new SelectToLineBeginNonBlank();
                slctToLineBeginNB.execute();
            } else if (m.equals("b")) {
                this._tm.selectWordsBack(c);
            } else if (m.equals("E")) {
                this._tm.selectNextWhiteSpace(c);
            } else if (m.startsWith("t") && m.length() > 1) {
                this._tm.selectToCharacter(c, m.charAt(1), false);
            } else if (m.startsWith("f") && m.length() > 1) {
                this._tm.selectToCharacter(c, m.charAt(1), true);
            } else if (m.startsWith("T") && m.length() > 1) {
                this._tm.selectToCharacterBackward(c, m.charAt(1), false);
            } else if (m.startsWith("F") && m.length() > 1) {
                this._tm.selectToCharacterBackward(c, m.charAt(1), true);
            } else if (m.equals(";")) {
                this._tm.searchToCharacterNext(c);
            } else if (m.equals(",")) {
                this._tm.searchToCharacterNextBackward(c);
            } else {
                if ((o.startsWith("c") || o.startsWith("d")) && m.startsWith("/")) {
                    ArrayList<Command> commands = new ArrayList<Command>();
                    commands.add(new ExtendSelectionToOffset(this._tm.getCaretPosition()));
                    commands.add(new YankSelection());
                    commands.add(new DeleteSelection(checkLastDelimiter));
                    if (o.startsWith("c")) {
                        commands.add(new SwitchToInsertModeCommand(this._viLayer));
                    }
                    this._searchDelegate = new SearchDelegate(this._search, new GroupCommand(commands));
                    this._cmdString = m;
                    this.eval();
                    return;
                }
                return;
            }
            YankSelection yankSelection = new YankSelection();
            yankSelection.execute();
            DeleteSelection deleteSelection = new DeleteSelection(checkLastDelimiter);
            deleteSelection.execute();
        }
        if (o.startsWith("c") || o.startsWith("S") || o.startsWith("C")) {
            this._viLayer.switchToInsertMode();
        }
        this._prevCmdString = this._cmdString;
        this.clear();
    }

    private boolean evalSelectionCommands(String o, int c) {
        if (this._tm.getSelection().getLength() > 0) {
            if (o.equals("d") || o.equals("x")) {
                YankSelection yankSelection = new YankSelection();
                yankSelection.execute();
                DeleteSelection deleteSelection = new DeleteSelection(true);
                deleteSelection.execute();
            } else if (o.equals("c") || o.equals("s")) {
                DeleteSelection deleteSelection = new DeleteSelection(false);
                deleteSelection.execute();
                this._viLayer.leaveVisualMode();
                this._viLayer.switchToInsertMode();
            } else if (o.equals("y")) {
                YankSelection yankSelection = new YankSelection();
                yankSelection.execute();
                this._tm.setVisualSelection(this._tm.getCaretPosition(), 0);
            } else if (o.equals("~")) {
                ChangeCaseSelection command = new ChangeCaseSelection();
                command.execute();
            } else if (o.equals("<")) {
                ShiftSelection shiftSelection = new ShiftSelection(c, 0);
                shiftSelection.execute();
            } else if (o.equals(">")) {
                ShiftSelection shiftSelection = new ShiftSelection(c, 1);
                shiftSelection.execute();
            } else {
                return false;
            }
            this.clear();
            this._prevCmdString = "";
            if (this._viLayer.isInVisualMode()) {
                this._viLayer.leaveVisualMode();
            }
            return true;
        }
        return false;
    }

    private void evalYankCommand(String o, String m, int c) {
        Command select = SelectionCommandFactory.createCommand(o, m, c);
        if (select != null) {
            select.execute();
        } else {
            SelectLines selectLines;
            if (m.equals("y") || o.equals("Y")) {
                selectLines = new SelectLines(c, 1, false);
                selectLines.execute();
            } else if (m.equals("<CD>") || m.equals("j")) {
                selectLines = new SelectLines(c + 1, 1, false);
                selectLines.execute();
            } else if (m.equals("<CU>") || m.equals("k")) {
                selectLines = new SelectLines(c, 0, false);
                selectLines.execute();
            } else if (m.equals("<CR>") || m.equals("h")) {
                this._tm.selectCharactersBackwards(c);
            } else if (m.equals("<CL>") || m.equals("l")) {
                this._tm.selectCharacters(c);
            } else if (m.equals("$")) {
                SelectToLineEnd selectToLineEnd = new SelectToLineEnd();
                selectToLineEnd.execute();
            } else if (m.equals("0")) {
                SelectToLineBegin selectToLineBegin = new SelectToLineBegin();
                selectToLineBegin.execute();
            } else if (m.equals("^")) {
                SelectToLineBeginNonBlank slctToLineBeginNB = new SelectToLineBeginNonBlank();
                slctToLineBeginNB.execute();
            } else if (m.equals("b")) {
                this._tm.selectWordsBack(c);
            } else if (m.equals("E")) {
                this._tm.selectNextWhiteSpace(c);
            } else if (m.startsWith("t") && m.length() > 1) {
                this._tm.searchCharacter(c, m.charAt(1), false);
            } else if (m.startsWith("f") && m.length() > 1) {
                this._tm.searchCharacter(c, m.charAt(1), true);
            } else if (m.startsWith("T") && m.length() > 1) {
                this._tm.searchCharacterBackward(c, m.charAt(1), false);
            } else if (m.startsWith("F") && m.length() > 1) {
                this._tm.searchCharacterBackward(c, m.charAt(1), true);
            } else if (m.equals(";")) {
                this._tm.searchToCharacterNext(c);
            } else if (m.equals(",")) {
                this._tm.searchToCharacterNextBackward(c);
            } else {
                return;
            }
            YankSelection yankSelection = new YankSelection();
            yankSelection.execute();
        }
        this.clear();
    }

    private boolean evalMotionCommand(String o, int c, boolean uc) {
        block24: {
            try {
                Command command = MotionCommandFactory.createCommand(o, c, uc);
                if (command != null) {
                    command.execute();
                    break block24;
                }
                if (o.equals("n")) {
                    this._search.searchNext();
                    break block24;
                }
                if (o.equals("N")) {
                    this._search.searchPrevious();
                    break block24;
                }
                if (o.equals("*")) {
                    this._search.searchCurrentWord();
                    break block24;
                }
                if (o.equals("#")) {
                    this._search.searchCurrentWordBackwards();
                    break block24;
                }
                if (o.equals("$")) {
                    this._tm.cursorToLineEnd();
                    break block24;
                }
                if (o.equals("%")) {
                    MatchBrace mb = new MatchBrace();
                    mb.execute();
                    break block24;
                }
                if (o.equals("^")) {
                    this._tm.cursorToLineFirstNonBlank();
                    break block24;
                }
                if (o.equals("e")) {
                    this._tm.cursorWordEnd(c);
                    break block24;
                }
                if (o.equals("E")) {
                    this._tm.cursorNextWhiteSpace(c);
                    break block24;
                }
                if (o.startsWith("f") && o.length() > 1) {
                    this._tm.searchCharacter(c, o.charAt(1), true);
                    break block24;
                }
                if (o.startsWith("T") && o.length() > 1) {
                    this._tm.searchCharacterBackward(c, o.charAt(1), false);
                    break block24;
                }
                if (o.startsWith("F") && o.length() > 1) {
                    this._tm.searchCharacterBackward(c, o.charAt(1), true);
                    break block24;
                }
                if (o.equals(";")) {
                    this._tm.searchToCharacterNext(c);
                    break block24;
                }
                if (o.equals(",")) {
                    this._tm.searchToCharacterNextBackward(c);
                    break block24;
                }
                if (o.equals("H")) {
                    this._tm.cursorToLine(this._tm.getTextViewer().getTopIndex() + c - 1, true);
                    break block24;
                }
                if (o.equals("L")) {
                    this._tm.cursorToLine(this._tm.getTextViewer().getBottomIndex() - c + 1, true);
                    break block24;
                }
                if (o.equals("M")) {
                    int middle = this._tm.getTextViewer().getTopIndex() + this._tm.getTextViewer().getBottomIndex();
                    this._tm.cursorToLine(middle /= 2, true);
                    break block24;
                }
                if (o.equals("<PU>")) {
                    this._tm.pageUp(c);
                    break block24;
                }
                if (o.equals("<PD>")) {
                    this._tm.pageDown(c);
                    break block24;
                }
                if (o.equals("<SU>")) {
                    this._tm.scrollUp(c);
                    break block24;
                }
                if (o.equals("<SD>")) {
                    this._tm.scrollDown(c);
                    break block24;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clear();
        return true;
    }

    private boolean evalColonCommand(String command) {
        block31: {
            int line;
            this._extendedCommandHistory.add(command);
            try {
                line = Integer.parseInt(command);
            }
            catch (NumberFormatException numberFormatException) {
                line = -1;
            }
            if (command.equals("q")) {
                try {
                    if (!this._tm.getTextEditor().isSaveOnCloseNeeded()) {
                        this._tm.getTextEditor().close(false);
                        break block31;
                    }
                    MessageDialog.openInformation((Shell)this._tm.getTextEditor().getSite().getWorkbenchWindow().getShell(), (String)"Can't close buffer", (String)"There are unsaved changes. To override use :q!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equals("q!")) {
                try {
                    this._tm.getTextEditor().close(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equals("w")) {
                try {
                    ITextEditor editor = this._tm.getTextEditor();
                    IProgressMonitor pm = editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
                    editor.doSave(pm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equals("wq") || command.equals("x")) {
                try {
                    this._tm.getTextEditor().close(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equals("wq!")) {
                try {
                    ITextEditor editor = this._tm.getTextEditor();
                    IProgressMonitor pm = editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
                    editor.doSave(pm);
                    editor.close(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line != -1) {
                this._tm.cursorToLine(line - 1, true);
            } else if (command.startsWith("set")) {
                this.evalPreferenceSetting(command);
            } else if (command.startsWith("%s/")) {
                try {
                    ReplaceString repstr = new ReplaceString(command);
                    repstr.execute();
                    this._prevCmdString = ":" + command + String.valueOf('\r');
                }
                catch (Exception exception) {
                    MessageDialog.openInformation((Shell)this._tm.getTextEditor().getSite().getWorkbenchWindow().getShell(), (String)"Error", (String)"Invalid _cmdString: usage: :%s/<search_for>/<replace_with>/g");
                    return false;
                }
            } else {
                this.clear();
                return false;
            }
        }
        this.clear();
        return true;
    }

    private void evalPreferenceSetting(String command) {
        StringTokenizer st = new StringTokenizer(command);
        st.nextToken();
        if (st.hasMoreTokens()) {
            String name = st.nextToken();
            String value = null;
            if (st.hasMoreTokens()) {
                value = st.nextToken();
            }
            ViPreferenceService.getInstance().eval(name, value);
        }
    }

    public void setUndoManager(IUndoManager undoManager) {
        this._undoManager = undoManager;
    }

    public void beginCompoundChange() {
        this._undoManager.beginCompoundChange();
    }

    public void endCompoundChange() {
        this._undoManager.endCompoundChange();
    }
}

