/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propsearch.search.internal.ui.text;

import java.text.Collator;
import java.text.MessageFormat;
import java.util.HashMap;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.ui.text.EditorOpener;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.ui.text.FileSearchQuery;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.ui.text.FileTableContentProvider;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.ui.text.FileTreeContentProvider;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.ui.text.NewTextSearchActionGroup;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.ui.text.ReplaceAction2;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.ui.text.SortAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.internal.ui.text.ResourceTransferDragAdapter;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;

public class FileSearchPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    static /* synthetic */ Class class$org$eclipse$ui$part$IShowInTargetList;
    private ActionGroup fActionGroup;
    private IFileSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private EditorOpener fEditorOpener = new EditorOpener();
    private IPropertyChangeListener fPropertyChangeListener;
    private SortAction fSortByNameAction = new SortAction(SearchMessages.FileSearchPage_sort_name_label, this, 2);
    private SortAction fSortByPathAction = new SortAction(SearchMessages.FileSearchPage_sort_path_label, this, 3);

    public FileSearchPage() {
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (("org.eclipse.search.limitTable".equals(event.getProperty()) || "org.eclipse.search.limitTableTo".equals(event.getProperty())) && FileSearchPage.this.getViewer() instanceof TableViewer) {
                    FileSearchPage.this.getViewPart().updateLabel();
                    FileSearchPage.this.getViewer().refresh();
                }
            }
        };
        SearchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        int ops = 5;
        DelegatingDragAdapter adapter = new DelegatingDragAdapter();
        adapter.addDragSourceListener((TransferDragSourceListener)new ResourceTransferDragAdapter((ISelectionProvider)viewer));
        viewer.addDragSupport(ops, transfers, (DragSourceListener)adapter);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.FileSearchPage_sort_by_label);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider((AbstractTextSearchViewPage)this, this.fCurrentSortOrder);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)innerLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new FileTableContentProvider(this));
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider((AbstractTextSearchViewPage)this, 1);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)innerLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new FileTreeContentProvider((AbstractTreeViewer)viewer));
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    public void dispose() {
        this.fActionGroup.dispose();
        SearchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
        FileSearchQuery query = (FileSearchQuery)this.getInput().getQuery();
        if (!"".equals(query.getSearchString())) {
            ReplaceAction2 replaceAll;
            ReplaceAction2 replaceAction = new ReplaceAction2(this, (IStructuredSelection)this.getViewer().getSelection());
            if (replaceAction.isEnabled()) {
                mgr.appendToGroup("group.reorganize", (IAction)replaceAction);
            }
            if ((replaceAll = new ReplaceAction2(this)).isEnabled()) {
                mgr.appendToGroup("group.reorganize", (IAction)replaceAll);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if ((class$org$eclipse$ui$part$IShowInTargetList == null ? (class$org$eclipse$ui$part$IShowInTargetList = FileSearchPage.class$("org.eclipse.ui.part.IShowInTargetList")) : class$org$eclipse$ui$part$IShowInTargetList).equals(adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    public String getLabel() {
        String label = super.getLabel();
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            int fileCount;
            int itemCount;
            TableViewer tv = (TableViewer)viewer;
            AbstractTextSearchResult result = this.getInput();
            if (result != null && (itemCount = ((IStructuredContentProvider)tv.getContentProvider()).getElements((Object)this.getInput()).length) < (fileCount = this.getInput().getElements().length)) {
                String format = SearchMessages.FileSearchPage_limited_format;
                return MessageFormat.format(format, label, new Integer(itemCount), new Integer(fileCount));
            }
        }
        return label;
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    public void restoreState(IMemento memento) {
        Integer value;
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException e) {
            this.fCurrentSortOrder = this.fSortByNameAction.getSortOrder();
        }
        if (memento != null && (value = memento.getInteger(KEY_SORTING)) != null) {
            this.fCurrentSortOrder = value;
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void setSortOrder(int sortOrder) {
        this.fCurrentSortOrder = sortOrder;
        DecoratingLabelProvider lpWrapper = (DecoratingLabelProvider)this.getViewer().getLabelProvider();
        ((FileLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        this.getViewer().refresh();
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewTextSearchActionGroup((IViewPart)part);
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        IEditorPart editor = this.fEditorOpener.open(match, activate);
        if (offset != 0 && length != 0) {
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(offset, length);
            } else if (editor != null) {
                this.showWithMarker(editor, file, offset, length);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        IMarker marker = null;
        marker = file.createMarker("org.eclipse.search.searchmarker");
        HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
        attributes.put("charStart", new Integer(offset));
        attributes.put("charEnd", new Integer(offset + length));
        marker.setAttributes(attributes);
        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        Object var8_8 = null;
        if (marker == null) return;
        try {
            marker.delete();
            return;
        }
        catch (CoreException e) {
        }
        return;
        {
            catch (CoreException e) {
                throw new PartInitException(SearchMessages.FileSearchPage_error_marker, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (marker == null) throw throwable;
            try {
                marker.delete();
                throw throwable;
            }
            catch (CoreException e) {
            }
            throw throwable;
        }
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerSorter {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            super(null);
            this.fLabelProvider = labelProvider;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getCollator().compare(name1, name2);
        }

        public final Collator getCollator() {
            if (this.collator == null) {
                this.collator = Collator.getInstance();
            }
            return this.collator;
        }
    }
}

