/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propsearch.search.internal.core.text;

import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.core.SearchScope;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.core.text.DocumentCharSequence;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.core.text.FileCharSequenceProvider;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.core.text.ITextSearchResultCollector;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.core.text.MatchLocator;
import jp.gr.java_conf.ussiy.app.propsearch.util.EncodeChanger;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextSearchVisitor
implements IResourceProxyVisitor {
    private ITextSearchResultCollector fCollector;
    private Map fDocumentsInEditors;
    private final FileCharSequenceProvider fFileCharSequenceProvider;
    private long fLastUpdateTime;
    private MatchLocator fLocator;
    private int fNumberOfFilesToScan;
    private int fNumberOfScannedFiles;
    private IProgressMonitor fProgressMonitor;
    private SearchScope fScope;
    private final MultiStatus fStatus;
    private boolean fVisitDerived;

    public TextSearchVisitor(MatchLocator locator, SearchScope scope, boolean visitDerived, ITextSearchResultCollector collector, MultiStatus status, int fileCount) {
        this.fScope = scope;
        this.fCollector = collector;
        this.fStatus = status;
        this.fProgressMonitor = collector.getProgressMonitor();
        this.fLocator = locator;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = fileCount;
        this.fVisitDerived = visitDerived;
        this.fFileCharSequenceProvider = new FileCharSequenceProvider();
    }

    private Map evalNonFileBufferDocuments() {
        HashMap result = new HashMap();
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private void evaluateTextEditor(Map result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath());
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException e) {
            return "unknown";
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file) {
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = (IDocument)this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    public void process() {
        this.fDocumentsInEditors = this.evalNonFileBufferDocuments();
        IResource[] roots = this.fScope.getRootElements();
        int i = 0;
        while (i < roots.length) {
            try {
                roots[i].accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                this.fStatus.add(ex.getStatus());
            }
            ++i;
        }
        this.fDocumentsInEditors = null;
    }

    private void updateProgressMonitor() {
        long currTime;
        ++this.fNumberOfScannedFiles;
        if (this.fNumberOfScannedFiles < this.fNumberOfFilesToScan && (currTime = System.currentTimeMillis()) - this.fLastUpdateTime > 1000L) {
            Object[] args = new Object[]{new Integer(this.fNumberOfScannedFiles + 1), new Integer(this.fNumberOfFilesToScan)};
            this.fProgressMonitor.setTaskName(Messages.format((String)SearchMessages.TextSearchVisitor_scanning, (Object[])args));
            this.fLastUpdateTime = currTime;
        }
        this.fProgressMonitor.worked(1);
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(IResourceProxy proxy) {
        block26: {
            if (proxy.getType() != 1) {
                return true;
            }
            if (!this.fVisitDerived) {
                if (proxy.isDerived()) return false;
            }
            if (!this.fScope.matchesFileName(proxy.getName())) {
                return false;
            }
            try {
                boolean bl;
                block25: {
                    try {
                        if (this.fLocator.isEmpty()) {
                            this.fCollector.accept(proxy, -1, 0);
                            bl = false;
                            Object var10_5 = null;
                            break block25;
                        }
                        IFile file = (IFile)proxy.requestResource();
                        IDocument document = this.getOpenDocument(file);
                        if (document != null) {
                            document.set(EncodeChanger.unicodeEsc2Unicode(document.get()));
                            this.fLocator.locateMatches(this.fProgressMonitor, new DocumentCharSequence(document), this.fCollector, proxy);
                            break block26;
                        }
                        CharSequence seq = null;
                        try {
                            seq = this.fFileCharSequenceProvider.newCharSequence(file);
                            this.fLocator.locateMatches(this.fProgressMonitor, seq, this.fCollector, proxy);
                            break block26;
                        }
                        catch (FileCharSequenceProvider.FileCharSequenceException e) {
                            e.throwWrappedException();
                            break block26;
                        }
                        finally {
                            if (seq != null) {
                                try {
                                    this.fFileCharSequenceProvider.releaseCharSequence(seq);
                                }
                                catch (IOException e) {
                                    SearchPlugin.log((Throwable)e);
                                }
                            }
                        }
                    }
                    catch (UnsupportedCharsetException e) {
                        IFile file = (IFile)proxy.requestResource();
                        Object[] args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                        String message = Messages.format((String)SearchMessages.TextSearchVisitor_unsupportedcharset, (Object[])args);
                        this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                        Object var10_7 = null;
                        this.updateProgressMonitor();
                        return false;
                    }
                    catch (IllegalCharsetNameException e) {
                        IFile file = (IFile)proxy.requestResource();
                        Object[] args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                        String message = Messages.format((String)SearchMessages.TextSearchVisitor_illegalcharset, (Object[])args);
                        this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                        Object var10_8 = null;
                        this.updateProgressMonitor();
                        return false;
                    }
                    catch (IOException e) {
                        IFile file = (IFile)proxy.requestResource();
                        Object[] args = new String[]{this.getExceptionMessage(e), file.getFullPath().makeRelative().toString()};
                        String message = Messages.format((String)SearchMessages.TextSearchVisitor_error, (Object[])args);
                        this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                        Object var10_9 = null;
                        this.updateProgressMonitor();
                        return false;
                    }
                    catch (CoreException e) {
                        IFile file = (IFile)proxy.requestResource();
                        Object[] args = new String[]{this.getExceptionMessage((Exception)((Object)e)), file.getFullPath().makeRelative().toString()};
                        String message = Messages.format((String)SearchMessages.TextSearchVisitor_error, (Object[])args);
                        this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                        Object var10_10 = null;
                        this.updateProgressMonitor();
                        return false;
                    }
                }
                this.updateProgressMonitor();
                return bl;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.updateProgressMonitor();
                throw throwable;
            }
        }
        Object var10_6 = null;
        this.updateProgressMonitor();
        return false;
    }
}

