/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propsearch.search.internal.core.text;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternConstructor {
    private PatternConstructor() {
    }

    private static String asRegEx(String pattern) {
        StringBuffer out = new StringBuffer(pattern.length());
        boolean escaped = false;
        boolean quoting = false;
        int i = 0;
        while (i < pattern.length()) {
            char ch;
            if ((ch = pattern.charAt(i++)) == '*' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".*");
                escaped = false;
                continue;
            }
            if (ch == '?' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".");
                escaped = false;
                continue;
            }
            if (ch == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (ch == '\\' && escaped) {
                escaped = false;
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append("\\\\");
                continue;
            }
            if (!quoting) {
                out.append("\\Q");
                quoting = true;
            }
            if (escaped && ch != '*' && ch != '?' && ch != '\\') {
                out.append('\\');
            }
            out.append(ch);
            escaped = ch == '\\';
        }
        if (quoting) {
            out.append("\\E");
        }
        return out.toString();
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        if (!isRegexSearch) {
            pattern = PatternConstructor.asRegEx(pattern);
        }
        if (!isCaseSensitive) {
            return Pattern.compile(pattern, 74);
        }
        return Pattern.compile(pattern, 8);
    }
}

