/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propsearch.search.internal.core.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import jp.gr.java_conf.ussiy.app.propsearch.util.EncodeChanger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class FileCharSequenceProvider {
    public static int BUFFER_SIZE;
    private static int NUMBER_OF_BUFFERS;
    private FileCharSequence fReused = null;

    static {
        NUMBER_OF_BUFFERS = 3;
        BUFFER_SIZE = 524288;
    }

    public CharSequence newCharSequence(IFile file) throws CoreException, IOException {
        if (this.fReused == null) {
            return new FileCharSequence(file);
        }
        FileCharSequence curr = this.fReused;
        this.fReused = null;
        curr.reset(file);
        return curr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCharSequence(CharSequence seq) throws CoreException, IOException {
        block4: {
            if (seq instanceof FileCharSequence) {
                FileCharSequence curr = (FileCharSequence)seq;
                try {
                    curr.close();
                    Object var4_3 = null;
                    if (this.fReused != null) break block4;
                    this.fReused = curr;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.fReused == null) {
                        this.fReused = curr;
                    }
                    throw throwable;
                }
                {
                }
            }
        }
    }

    private final class FileCharSequence
    implements CharSequence {
        private IFile fFile;
        private Integer fLength;
        private Buffer fMostCurrentBuffer;
        private int fNumberOfBuffers = 0;
        private Reader fReader;
        private int fReaderPos;

        public FileCharSequence(IFile file) throws CoreException, IOException {
            this.reset(file);
        }

        public char charAt(int index) {
            Buffer current = this.fMostCurrentBuffer;
            if (current != null && current.contains(index)) {
                return current.get(index);
            }
            if (index < 0) {
                throw new IndexOutOfBoundsException("index must be larger than 0");
            }
            if (this.fLength != null && index >= this.fLength) {
                throw new IndexOutOfBoundsException("index must be smaller than length");
            }
            try {
                Buffer buffer = this.getBuffer(index);
                if (buffer == null) {
                    throw new IndexOutOfBoundsException("index must be smaller than length");
                }
                if (buffer != this.fMostCurrentBuffer) {
                    if (buffer.getNext() != this.fMostCurrentBuffer) {
                        buffer.removeFromChain();
                        buffer.insertBefore(this.fMostCurrentBuffer);
                    }
                    this.fMostCurrentBuffer = buffer;
                }
                return buffer.get(index);
            }
            catch (IOException e) {
                throw new FileCharSequenceException(e);
            }
            catch (CoreException e) {
                throw new FileCharSequenceException(e);
            }
        }

        private void clearReader() throws IOException {
            if (this.fReader != null) {
                this.fReader.close();
            }
            this.fReader = null;
            this.fReaderPos = Integer.MAX_VALUE;
        }

        public void close() throws IOException {
            this.clearReader();
        }

        private boolean fillBuffer(Buffer buffer, int pos) throws CoreException, IOException {
            if (this.fReaderPos > pos) {
                this.initializeReader();
            }
            do {
                boolean endReached = buffer.fill(this.fReader, this.fReaderPos);
                this.fReaderPos = buffer.getEndOffset();
                if (!endReached) continue;
                this.fLength = new Integer(this.fReaderPos);
                this.fReaderPos = Integer.MAX_VALUE;
                return true;
            } while (this.fReaderPos <= pos);
            return true;
        }

        private Buffer findBufferToUse() {
            if (this.fNumberOfBuffers < NUMBER_OF_BUFFERS) {
                ++this.fNumberOfBuffers;
                Buffer newBuffer = new Buffer();
                if (this.fMostCurrentBuffer == null) {
                    this.fMostCurrentBuffer = newBuffer;
                    return newBuffer;
                }
                newBuffer.insertBefore(this.fMostCurrentBuffer);
                return newBuffer;
            }
            return this.fMostCurrentBuffer.getPrevious();
        }

        private Buffer getBuffer(int pos) throws IOException, CoreException {
            Buffer curr = this.fMostCurrentBuffer;
            if (curr != null) {
                do {
                    if (curr.contains(pos)) {
                        return curr;
                    }
                    curr = curr.getNext();
                } while (curr != this.fMostCurrentBuffer);
            }
            Buffer buf = this.findBufferToUse();
            this.fillBuffer(buf, pos);
            if (buf.contains(pos)) {
                return buf;
            }
            return null;
        }

        public String getSubstring(int start, int length) throws IOException, CoreException {
            int pos = start;
            int endPos = start + length;
            if (this.fLength != null && endPos > this.fLength) {
                throw new IndexOutOfBoundsException("end must be smaller than length");
            }
            StringBuffer res = new StringBuffer(length);
            Buffer buffer = this.getBuffer(pos);
            while (pos < endPos && buffer != null) {
                int bufEnd = buffer.getEndOffset();
                if (bufEnd >= endPos) {
                    return buffer.append(res, pos, endPos - pos).toString();
                }
                buffer.append(res, pos, bufEnd - pos);
                pos = bufEnd;
                buffer = this.getBuffer(pos);
            }
            return res.toString();
        }

        private void initializeReader() throws CoreException, IOException {
            if (this.fReader != null) {
                this.fReader.close();
            }
            InputStream stream = this.fFile.getContents(false);
            if (this.fFile != null && this.fFile.getFileExtension() != null && this.fFile.getFileExtension().equals("properties")) {
                byte[] tmpBuf = new byte[102400];
                int getSize = 0;
                int totalGetSize = 0;
                byte[] content = new byte[]{};
                while ((getSize = stream.read(tmpBuf)) != -1) {
                    content = new byte[totalGetSize + getSize];
                    System.arraycopy(tmpBuf, 0, content, totalGetSize, getSize);
                    totalGetSize += getSize;
                }
                this.fReader = new BufferedReader(new StringReader(EncodeChanger.unicodeEsc2Unicode(new String(content, this.fFile.getCharset()))));
            } else {
                this.fReader = new InputStreamReader(this.fFile.getContents(), this.fFile.getCharset());
            }
            this.fReaderPos = 0;
        }

        public int length() {
            if (this.fLength == null) {
                try {
                    this.getBuffer(Integer.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new FileCharSequenceException(e);
                }
                catch (CoreException e) {
                    throw new FileCharSequenceException(e);
                }
            }
            return this.fLength;
        }

        public void reset(IFile file) throws CoreException, IOException {
            this.fFile = file;
            this.fLength = null;
            Buffer curr = this.fMostCurrentBuffer;
            if (curr != null) {
                do {
                    curr.reset();
                    curr = curr.getNext();
                } while (curr != this.fMostCurrentBuffer);
            }
            this.initializeReader();
        }

        public CharSequence subSequence(int start, int end) {
            if (end < start) {
                throw new IndexOutOfBoundsException("end cannot be smaller than start");
            }
            if (start < 0) {
                throw new IndexOutOfBoundsException("start must be larger than 0");
            }
            if (this.fLength != null && end > this.fLength) {
                throw new IndexOutOfBoundsException("end must be smaller than length");
            }
            return new CharSubSequence(this, start, end - start);
        }

        public String toString() {
            int len = this.fLength != null ? this.fLength : 4000;
            StringBuffer res = new StringBuffer(len);
            try {
                Buffer buffer = this.getBuffer(0);
                while (buffer != null) {
                    buffer.appendAll(res);
                    buffer = this.getBuffer(res.length());
                }
                return res.toString();
            }
            catch (IOException e) {
                throw new FileCharSequenceException(e);
            }
            catch (CoreException e) {
                throw new FileCharSequenceException(e);
            }
        }
    }

    private static final class Buffer {
        private final char[] fBuf = new char[BUFFER_SIZE];
        private int fLength;
        private Buffer fNext;
        private int fOffset;
        private Buffer fPrevious;

        public Buffer() {
            this.reset();
            this.fNext = this;
            this.fPrevious = this;
        }

        public StringBuffer append(StringBuffer buf, int start, int length) {
            return buf.append(this.fBuf, start - this.fOffset, length);
        }

        public StringBuffer appendAll(StringBuffer buf) {
            return buf.append(this.fBuf, 0, this.fLength);
        }

        public boolean contains(int pos) {
            int offset = this.fOffset;
            return offset <= pos && pos < offset + this.fLength;
        }

        public boolean fill(Reader reader, int pos) throws IOException {
            int res = reader.read(this.fBuf);
            if (res == -1) {
                this.fOffset = pos;
                this.fLength = 0;
                return true;
            }
            int charsRead = res;
            while (charsRead < BUFFER_SIZE) {
                res = reader.read(this.fBuf, charsRead, BUFFER_SIZE - charsRead);
                if (res == -1) {
                    this.fOffset = pos;
                    this.fLength = charsRead;
                    return true;
                }
                charsRead += res;
            }
            this.fOffset = pos;
            this.fLength = BUFFER_SIZE;
            return false;
        }

        public char get(int pos) {
            return this.fBuf[pos - this.fOffset];
        }

        public int getEndOffset() {
            return this.fOffset + this.fLength;
        }

        public Buffer getNext() {
            return this.fNext;
        }

        public Buffer getPrevious() {
            return this.fPrevious;
        }

        public void insertBefore(Buffer other) {
            this.fNext = other;
            this.fPrevious = other.fPrevious;
            this.fPrevious.fNext = this;
            other.fPrevious = this;
        }

        public void removeFromChain() {
            this.fPrevious.fNext = this.fNext;
            this.fNext.fPrevious = this.fPrevious;
            this.fNext = this;
            this.fPrevious = this;
        }

        public void reset() {
            this.fOffset = -1;
            this.fLength = 0;
        }
    }

    private static final class CharSubSequence
    implements CharSequence {
        private final FileCharSequence fParent;
        private final int fSequenceLength;
        private final int fSequenceOffset;

        public CharSubSequence(FileCharSequence parent, int offset, int length) {
            this.fParent = parent;
            this.fSequenceOffset = offset;
            this.fSequenceLength = length;
        }

        public char charAt(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index must be larger than 0");
            }
            if (index >= this.fSequenceLength) {
                throw new IndexOutOfBoundsException("index must be smaller than length");
            }
            return this.fParent.charAt(this.fSequenceOffset + index);
        }

        public int length() {
            return this.fSequenceLength;
        }

        public CharSequence subSequence(int start, int end) {
            if (end < start) {
                throw new IndexOutOfBoundsException("end cannot be smaller than start");
            }
            if (start < 0) {
                throw new IndexOutOfBoundsException("start must be larger than 0");
            }
            if (end > this.fSequenceLength) {
                throw new IndexOutOfBoundsException("end must be smaller or equal than length");
            }
            return this.fParent.subSequence(this.fSequenceOffset + start, this.fSequenceOffset + end);
        }

        public String toString() {
            try {
                return this.fParent.getSubstring(this.fSequenceOffset, this.fSequenceLength);
            }
            catch (IOException e) {
                throw new FileCharSequenceException(e);
            }
            catch (CoreException e) {
                throw new FileCharSequenceException(e);
            }
        }
    }

    public static class FileCharSequenceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        FileCharSequenceException(CoreException e) {
            super(e);
        }

        FileCharSequenceException(IOException e) {
            super(e);
        }

        public void throwWrappedException() throws CoreException, IOException {
            Throwable wrapped = this.getCause();
            if (wrapped instanceof CoreException) {
                throw (CoreException)wrapped;
            }
            if (wrapped instanceof IOException) {
                throw (IOException)wrapped;
            }
        }
    }
}

