/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propsearch.search.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.gr.java_conf.ussiy.app.propsearch.search.internal.core.text.PatternConstructor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.ui.IWorkingSet;

public class SearchScope {
    private static final boolean IS_CASE_SENSITIVE_FILESYSTEM = !new File("Temp").equals(new File("temp"));
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    private String fDescription;
    private Matcher[] fFileNameMatchers = null;
    private Set fFileNamePatterns = new HashSet(3);
    private final IResource[] fRootElements;

    private SearchScope(String description, IResource[] resources) {
        Assert.isNotNull((Object)description);
        this.fDescription = description;
        this.fRootElements = resources;
    }

    public void addFileNamePattern(String pattern) {
        if (this.fFileNamePatterns.add(pattern)) {
            this.fFileNameMatchers = null;
        }
    }

    private static void addToList(ArrayList res, IResource curr) {
        IPath currPath = curr.getFullPath();
        int k = res.size() - 1;
        while (k >= 0) {
            IResource other = (IResource)res.get(k);
            IPath otherPath = other.getFullPath();
            if (otherPath.isPrefixOf(currPath)) {
                return;
            }
            if (currPath.isPrefixOf(otherPath)) {
                res.remove(k);
            }
            --k;
        }
        res.add(curr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static IResource[] convertToResources(IWorkingSet[] workingSets) {
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < workingSets.length) {
            IAdaptable[] elements = workingSets[i].getElements();
            int k = 0;
            while (k < elements.length) {
                IResource curr = (IResource)elements[k].getAdapter(class$org$eclipse$core$resources$IResource == null ? SearchScope.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
                if (curr != null) {
                    SearchScope.addToList(res, curr);
                }
                ++k;
            }
            ++i;
        }
        return res.toArray(new IResource[res.size()]);
    }

    public String getDescription() {
        return this.fDescription;
    }

    private Matcher[] getFileNameMatchers() {
        if (this.fFileNameMatchers == null) {
            this.fFileNameMatchers = new Matcher[this.fFileNamePatterns.size()];
            int i = 0;
            Iterator iter = this.fFileNamePatterns.iterator();
            while (iter.hasNext()) {
                String ext = (String)iter.next();
                Pattern pattern = PatternConstructor.createPattern(ext, IS_CASE_SENSITIVE_FILESYSTEM, false);
                this.fFileNameMatchers[i++] = pattern.matcher("");
            }
        }
        return this.fFileNameMatchers;
    }

    public String getFileNamePatternDescription() {
        Object[] ext = this.fFileNamePatterns.toArray(new String[this.fFileNamePatterns.size()]);
        Arrays.sort(ext);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ext.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append((String)ext[i]);
            ++i;
        }
        return buf.toString();
    }

    public IResource[] getRootElements() {
        return this.fRootElements;
    }

    public boolean matchesFileName(String fileName) {
        Matcher[] matchers = this.getFileNameMatchers();
        int i = 0;
        while (i < matchers.length) {
            if (matchers[i].reset(fileName).matches()) {
                return true;
            }
            ++i;
        }
        return matchers.length == 0;
    }

    public static SearchScope newSearchScope(String description, IWorkingSet[] workingSets) {
        return new SearchScope(description, SearchScope.convertToResources(workingSets));
    }

    public static SearchScope newSearchScope(String description, IResource[] resources) {
        return new SearchScope(description, SearchScope.removeRedundantEntries(resources));
    }

    public static SearchScope newWorkspaceScope() {
        return new SearchScope(SearchMessages.WorkspaceScope, new IResource[]{ResourcesPlugin.getWorkspace().getRoot()});
    }

    private static IResource[] removeRedundantEntries(IResource[] elements) {
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            IResource curr = elements[i];
            SearchScope.addToList(res, curr);
            ++i;
        }
        return res.toArray(new IResource[res.size()]);
    }
}

