/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.TextSearchOperation;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultView;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.SearchResultViewer;
import org.eclipse.search.internal.ui.util.ExtendedDialogWindow;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;

class ReplaceDialog
extends ExtendedDialogWindow {
    private static final int REPLACE = 1025;
    private static final int REPLACE_ALL = 1027;
    private static final int REPLACE_ALL_IN_FILE = 1026;
    private static final int SKIP = 1028;
    private static final int SKIP_ALL = 1030;
    private static final int SKIP_FILE = 1029;
    private IReusableEditor fEditor;
    private List fMarkers;
    private TextSearchOperation fOperation;
    private Button fReplaceAllButton;
    private Button fReplaceAllInFileButton;
    private Button fReplaceButton;
    private Button fSkipButton;
    private Button fSkipFileButton;
    private boolean fSkipReadonly = false;
    private Text fTextField;

    protected ReplaceDialog(Shell parentShell, List entries, TextSearchOperation operation) {
        super(parentShell);
        Assert.isNotNull((Object)entries);
        Assert.isNotNull((Object)((Object)operation));
        this.fMarkers = new ArrayList();
        this.initializeMarkers(entries);
        this.fOperation = operation;
    }

    private int askForSkip(IFile file) {
        boolean showSkip;
        String message = SearchMessages.getFormattedString((String)"ReadOnlyDialog.message", (Object)file.getFullPath().toOSString());
        String[] buttonLabels = null;
        boolean bl = showSkip = this.countResources() > 1;
        if (showSkip) {
            String skipLabel = SearchMessages.getString((String)"ReadOnlyDialog.skipFile");
            String skipAllLabel = SearchMessages.getString((String)"ReadOnlyDialog.skipAll");
            buttonLabels = new String[]{skipLabel, skipAllLabel, IDialogConstants.CANCEL_LABEL};
        } else {
            buttonLabels = new String[]{IDialogConstants.CANCEL_LABEL};
        }
        MessageDialog msd = new MessageDialog(this.getShell(), this.getShell().getText(), null, message, 1, buttonLabels, 0);
        int rc = msd.open();
        switch (rc) {
            case 0: {
                return showSkip ? 1029 : 1;
            }
            case 1: {
                return 1030;
            }
        }
        return 1;
    }

    protected void buttonPressed(int buttonId) {
        final String replaceText = this.fTextField.getText();
        try {
            switch (buttonId) {
                case 1028: {
                    this.skip();
                    break;
                }
                case 1029: {
                    this.skipFile();
                    break;
                }
                case 1025: {
                    this.run(false, true, (IRunnableWithProgress)new ReplaceOperation(){

                        protected void doReplace(IProgressMonitor pm) throws BadLocationException, CoreException {
                            ReplaceDialog.this.replace(pm, replaceText);
                        }
                    });
                    this.gotoCurrentMarker();
                    break;
                }
                case 1026: {
                    this.run(false, true, (IRunnableWithProgress)new ReplaceOperation(){

                        protected void doReplace(IProgressMonitor pm) throws BadLocationException, CoreException {
                            ReplaceDialog.this.replaceInFile(pm, replaceText);
                        }
                    });
                    this.gotoCurrentMarker();
                    break;
                }
                case 1027: {
                    this.run(false, true, (IRunnableWithProgress)new ReplaceOperation(){

                        protected void doReplace(IProgressMonitor pm) throws BadLocationException, CoreException {
                            ReplaceDialog.this.replaceAll(pm, replaceText);
                        }
                    });
                    this.gotoCurrentMarker();
                    break;
                }
                default: {
                    super.buttonPressed(buttonId);
                    return;
                }
            }
        }
        catch (InvocationTargetException e) {
            SearchPlugin.log((Throwable)e);
            String message = SearchMessages.getFormattedString((String)"ReplaceDialog.error.unable_to_replace", (Object)this.getCurrentMarker().getFile().getName());
            MessageDialog.openError((Shell)this.getParentShell(), (String)this.getDialogTitle(), (String)message);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!(this.hasNextMarker() || this.hasNextFile() || this.canReplace())) {
            this.close();
        } else {
            this.enableButtons();
        }
    }

    private boolean canReplace() {
        return this.fMarkers.size() > 0;
    }

    private ReplaceMarker[] collectMarkers(IResource resource) {
        ArrayList<ReplaceMarker> matching = new ArrayList<ReplaceMarker>();
        int i = 0;
        while (i < this.fMarkers.size()) {
            ReplaceMarker marker = (ReplaceMarker)this.fMarkers.get(i);
            if (!marker.getFile().equals((Object)resource)) break;
            matching.add(marker);
            ++i;
        }
        ReplaceMarker[] markers = new ReplaceMarker[matching.size()];
        return matching.toArray(markers);
    }

    private int countResources() {
        IFile r = null;
        int count = 0;
        Iterator elements = this.fMarkers.iterator();
        while (elements.hasNext()) {
            ReplaceMarker element = (ReplaceMarker)elements.next();
            if (element.getFile().equals(r)) continue;
            ++count;
            r = element.getFile();
        }
        return count;
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.setText(this.getDialogTitle());
        this.gotoCurrentMarker();
        this.enableButtons();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fReplaceButton = this.createButton(parent, 1025, SearchMessages.getString((String)"ReplaceDialog.replace"), true);
        this.fReplaceAllInFileButton = this.createButton(parent, 1026, SearchMessages.getString((String)"ReplaceDialog.replaceAllInFile"), false);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(768));
        this.fReplaceAllButton = this.createButton(parent, 1027, SearchMessages.getString((String)"ReplaceDialog.replaceAll"), false);
        this.fSkipButton = this.createButton(parent, 1028, SearchMessages.getString((String)"ReplaceDialog.skip"), false);
        this.fSkipFileButton = this.createButton(parent, 1029, SearchMessages.getString((String)"ReplaceDialog.skipFile"), false);
        filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(768));
        super.createButtonsForButtonBar(parent);
        ((GridLayout)parent.getLayout()).numColumns = 4;
    }

    protected Control createPageArea(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        result.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.initializeDialogUnits((Control)result);
        Label label = new Label(result, 0);
        label.setText(SearchMessages.getString((String)"ReplaceDialog.replace_label"));
        Text clabel = new Text(result, 2048);
        clabel.setEnabled(false);
        clabel.setText(this.fOperation.getPattern());
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        clabel.setLayoutData((Object)gd);
        label = new Label(result, 0);
        label.setText(SearchMessages.getString((String)"ReplaceDialog.with_label"));
        this.fTextField = new Text(result, 2048);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fTextField.setLayoutData((Object)gd);
        this.fTextField.setFocus();
        new Label(result, 0);
        Button replaceWithRegex = new Button(result, 32);
        replaceWithRegex.setText(SearchMessages.getString((String)"ReplaceDialog.isRegex.label"));
        replaceWithRegex.setEnabled(false);
        replaceWithRegex.setSelection(false);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void createPositionsInFile(IFile file, IDocument doc) throws BadLocationException {
        Iterator markers = this.fMarkers.iterator();
        while (markers.hasNext()) {
            ReplaceMarker marker = (ReplaceMarker)markers.next();
            if (!marker.getFile().equals((Object)file)) {
                return;
            }
            marker.createPosition(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doReplaceInFile(IProgressMonitor pm, IFile file, String replacementText, ReplaceMarker[] markers) throws BadLocationException, CoreException {
        block21: {
            block19: {
                block18: {
                    block17: {
                        try {
                            if (file.isReadOnly()) {
                                file.getWorkspace().validateEdit(new IFile[]{file}, null);
                            }
                            if (file.isReadOnly()) {
                                if (this.fSkipReadonly) {
                                    this.skipFile();
                                    Object var15_5 = null;
                                    break block17;
                                }
                                int rc = this.askForSkip(file);
                                switch (rc) {
                                    case 1: {
                                        throw new OperationCanceledException();
                                    }
                                    case 1029: {
                                        this.skipFile();
                                        break block18;
                                    }
                                    case 1030: {
                                        this.fSkipReadonly = true;
                                        this.skipFile();
                                        break block19;
                                    }
                                }
                            }
                            ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
                            try {
                                bm.connect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                ITextFileBuffer fb = bm.getTextFileBuffer(file.getFullPath());
                                boolean wasDirty = fb.isDirty();
                                IDocument doc = fb.getDocument();
                                try {
                                    this.createPositionsInFile(file, doc);
                                    int i = 0;
                                    while (true) {
                                        if (i >= markers.length) {
                                            Object var11_16 = null;
                                            this.removePositonsInFile(file, doc);
                                            break;
                                        }
                                        doc.replace(markers[i].getOffset(), markers[i].getLength(), replacementText);
                                        this.fMarkers.remove(0);
                                        markers[i].delete();
                                        ++i;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var11_17 = null;
                                    this.removePositonsInFile(file, doc);
                                    throw throwable;
                                }
                                if (!wasDirty) {
                                    fb.commit((IProgressMonitor)new SubProgressMonitor(pm, 1), true);
                                }
                                Object var13_19 = null;
                            }
                            catch (Throwable throwable) {
                                Object var13_20 = null;
                                bm.disconnect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                throw throwable;
                            }
                            bm.disconnect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            break block21;
                        }
                        catch (Throwable throwable) {
                            Object var15_9 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return;
                }
                Object var15_6 = null;
                pm.done();
                return;
            }
            Object var15_7 = null;
            pm.done();
            return;
        }
        Object var15_8 = null;
        pm.done();
    }

    private void enableButtons() {
        this.fSkipButton.setEnabled(this.hasNextMarker());
        this.fSkipFileButton.setEnabled(this.hasNextFile());
        this.fReplaceButton.setEnabled(this.canReplace());
        this.fReplaceAllInFileButton.setEnabled(this.canReplace());
        this.fReplaceAllButton.setEnabled(this.canReplace());
    }

    private ReplaceMarker getCurrentMarker() {
        return (ReplaceMarker)this.fMarkers.get(0);
    }

    private String getDialogTitle() {
        return SearchMessages.getString((String)"ReplaceDialog.dialog.title");
    }

    protected Point getInitialLocation(Point initialSize) {
        SearchResultView view = (SearchResultView)SearchPlugin.getSearchResultView();
        if (view == null) {
            return super.getInitialLocation(initialSize);
        }
        Point result = new Point(0, 0);
        Control control = view.getViewer().getControl();
        Point size = control.getSize();
        Point location = control.toDisplay(control.getLocation());
        result.x = Math.max(0, location.x + size.x - initialSize.x);
        result.y = Math.max(0, location.y + size.y - initialSize.y);
        return result;
    }

    private void gotoCurrentMarker() {
        if (this.fMarkers.size() > 0) {
            ReplaceMarker marker = this.getCurrentMarker();
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            try {
                this.selectEntry(marker);
                ITextEditor editor = null;
                editor = SearchUI.reuseEditor() ? this.openEditorReuse(marker) : this.openEditorNoReuse(marker);
                editor.selectAndReveal(marker.getOffset(), marker.getLength());
                if (focusControl != null && !focusControl.isDisposed()) {
                    focusControl.setFocus();
                }
            }
            catch (PartInitException e) {
                String message = SearchMessages.getFormattedString((String)"ReplaceDialog.error.unable_to_open_text_editor", (Object)marker.getFile().getName());
                MessageDialog.openError((Shell)this.getParentShell(), (String)this.getDialogTitle(), (String)message);
            }
        }
    }

    private boolean hasNextFile() {
        if (!this.hasNextMarker()) {
            return false;
        }
        IFile currentFile = this.getCurrentMarker().getFile();
        int i = 0;
        while (i < this.fMarkers.size()) {
            if (!((ReplaceMarker)this.fMarkers.get(i)).getFile().equals((Object)currentFile)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasNextMarker() {
        return this.fMarkers.size() > 1;
    }

    private void initializeMarkers(List entries) {
        Iterator elements = entries.iterator();
        while (elements.hasNext()) {
            SearchResultViewEntry element = (SearchResultViewEntry)elements.next();
            List markerList = element.getMarkers();
            Iterator markers = markerList.iterator();
            while (markers.hasNext()) {
                IMarker marker = (IMarker)markers.next();
                int charStart = MarkerUtilities.getCharStart((IMarker)marker);
                if (charStart < 0 || MarkerUtilities.getCharEnd((IMarker)marker) <= charStart) continue;
                this.fMarkers.add(new ReplaceMarker(marker));
            }
        }
    }

    private boolean isEditorOpen(IWorkbenchPage page, IEditorPart editor) {
        if (editor != null) {
            IEditorReference[] parts = page.getEditorReferences();
            int i = 0;
            int j = 0;
            while (j < parts.length) {
                if (editor == parts[i++].getEditor(false)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editor.equals(editorRefs[i].getEditor(false))) {
                return editorRefs[i].isPinned();
            }
            ++i;
        }
        return false;
    }

    private ITextEditor openEditorNoReuse(ReplaceMarker marker) throws PartInitException {
        IFile file = marker.getFile();
        IWorkbenchPage activePage = SearchPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        ITextEditor textEditor = this.showOpenTextEditor(activePage, file);
        if (textEditor != null) {
            return textEditor;
        }
        return this.openNewTextEditor(file, activePage);
    }

    private ITextEditor openEditorReuse(ReplaceMarker marker) throws PartInitException {
        boolean showsSameInputType;
        boolean isOpen;
        IWorkbenchPage page = SearchPlugin.getActivePage();
        IFile file = marker.getFile();
        if (page == null) {
            return null;
        }
        ITextEditor textEditor = this.showOpenTextEditor(page, file);
        if (textEditor != null) {
            return textEditor;
        }
        String editorId = null;
        IEditorDescriptor desc = IDE.getDefaultEditor((IFile)file);
        if (desc != null && desc.isInternal()) {
            editorId = desc.getId();
        }
        boolean canBeReused = (isOpen = this.isEditorOpen(page, (IEditorPart)this.fEditor)) && !this.fEditor.isDirty() && !this.isPinned((IEditorPart)this.fEditor);
        boolean bl = showsSameInputType = this.fEditor != null && (editorId == null || this.fEditor.getSite().getId().equals(editorId));
        if (canBeReused) {
            if (showsSameInputType) {
                this.fEditor.setInput((IEditorInput)new FileEditorInput(file));
                page.bringToTop((IWorkbenchPart)this.fEditor);
                return (ITextEditor)this.fEditor;
            }
            page.closeEditor((IEditorPart)this.fEditor, false);
            this.fEditor = null;
        }
        return this.openNewTextEditor(file, page);
    }

    private ITextEditor openNewTextEditor(IFile file, IWorkbenchPage activePage) throws PartInitException {
        IEditorDescriptor desc = IDE.getDefaultEditor((IFile)file);
        if (desc != null) {
            String editorID = desc.getId();
            if (desc.isInternal()) {
                IEditorPart editor = activePage.openEditor((IEditorInput)new FileEditorInput(file), editorID);
                if (editor instanceof ITextEditor) {
                    if (editor instanceof IReusableEditor) {
                        this.fEditor = (IReusableEditor)editor;
                    }
                    return (ITextEditor)editor;
                }
                activePage.closeEditor(editor, false);
            }
        }
        IEditorPart editor = activePage.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.ui.DefaultTextEditor");
        return (ITextEditor)editor;
    }

    private void removePositonsInFile(IFile file, IDocument doc) {
        Iterator markers = this.fMarkers.iterator();
        while (markers.hasNext()) {
            ReplaceMarker marker = (ReplaceMarker)markers.next();
            if (!marker.getFile().equals((Object)file)) {
                return;
            }
            marker.deletePosition(doc);
        }
    }

    private void replace(IProgressMonitor pm, String replacementText) throws BadLocationException, CoreException {
        ReplaceMarker marker = this.getCurrentMarker();
        pm.beginTask(SearchMessages.getString((String)"ReplaceDialog.task.replace"), 10);
        this.replaceInFile(pm, marker.getFile(), replacementText, new ReplaceMarker[]{marker});
    }

    private void replaceAll(IProgressMonitor pm, String replacementText) throws BadLocationException, CoreException {
        int resourceCount = this.countResources();
        pm.beginTask(SearchMessages.getString((String)"ReplaceDialog.task.replace.replaceAll"), resourceCount);
        while (this.fMarkers.size() > 0) {
            this.replaceInFile((IProgressMonitor)new SubProgressMonitor(pm, 1, 0), replacementText);
        }
        pm.done();
    }

    private void replaceInFile(IProgressMonitor pm, IFile file, String replacementText, ReplaceMarker[] markers) throws BadLocationException, CoreException {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.doReplaceInFile(pm, file, replacementText, markers);
    }

    private void replaceInFile(IProgressMonitor pm, String replacementText) throws BadLocationException, CoreException {
        ReplaceMarker firstMarker = this.getCurrentMarker();
        ReplaceMarker[] markers = this.collectMarkers((IResource)firstMarker.getFile());
        pm.beginTask(SearchMessages.getFormattedString((String)"ReplaceDialog.task.replaceInFile", (Object)firstMarker.getFile().getFullPath().toOSString()), 4);
        this.replaceInFile(pm, firstMarker.getFile(), replacementText, markers);
    }

    private void selectEntry(ReplaceMarker marker) {
        SearchResultView view = (SearchResultView)SearchPlugin.getSearchResultView();
        if (view == null) {
            return;
        }
        SearchResultViewer viewer = view.getViewer();
        if (viewer == null) {
            return;
        }
        ISelection sel = viewer.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)sel;
        IFile file = marker.getFile();
        if (ss.size() == 1 && file.equals(ss.getFirstElement())) {
            return;
        }
        Table table = viewer.getTable();
        if (table == null || table.isDisposed()) {
            return;
        }
        int selectionIndex = table.getSelectionIndex();
        if (selectionIndex < 0) {
            selectionIndex = 0;
        }
        int i = 0;
        while (i < table.getItemCount()) {
            int currentTableIndex = (selectionIndex + i) % table.getItemCount();
            SearchResultViewEntry entry = (SearchResultViewEntry)viewer.getElementAt(currentTableIndex);
            if (file.equals(entry.getGroupByKey())) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)entry));
                return;
            }
            ++i;
        }
    }

    private ITextEditor showOpenTextEditor(IWorkbenchPage page, IFile file) {
        IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(file));
        if (editor instanceof ITextEditor) {
            page.bringToTop((IWorkbenchPart)editor);
            return (ITextEditor)editor;
        }
        return null;
    }

    private void skip() {
        this.fMarkers.remove(0);
        Assert.isTrue((this.fMarkers.size() > 0 ? 1 : 0) != 0);
        this.gotoCurrentMarker();
    }

    private void skipFile() {
        ReplaceMarker currentMarker = this.getCurrentMarker();
        if (currentMarker == null) {
            return;
        }
        IFile currentFile = currentMarker.getFile();
        while (this.fMarkers.size() > 0 && this.getCurrentMarker().getFile().equals((Object)currentFile)) {
            this.fMarkers.remove(0);
        }
        this.gotoCurrentMarker();
    }

    private static abstract class ReplaceOperation
    extends WorkspaceModifyOperation {
        private ReplaceOperation() {
        }

        protected abstract void doReplace(IProgressMonitor var1) throws BadLocationException, CoreException, IOException;

        public void execute(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                this.doReplace(monitor);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    private static class ReplaceMarker {
        private IMarker fMarker;
        private Position fPosition;

        ReplaceMarker(IMarker marker) {
            this.fMarker = marker;
        }

        public void createPosition(IDocument doc) throws BadLocationException {
            if (this.fPosition == null) {
                int charStart = MarkerUtilities.getCharStart((IMarker)this.fMarker);
                this.fPosition = new Position(charStart, MarkerUtilities.getCharEnd((IMarker)this.fMarker) - charStart);
                doc.addPosition(this.fPosition);
            }
        }

        public void delete() throws CoreException {
            this.fMarker.delete();
        }

        public void deletePosition(IDocument doc) {
            if (this.fPosition != null) {
                MarkerUtilities.setCharStart((IMarker)this.fMarker, (int)this.fPosition.getOffset());
                MarkerUtilities.setCharEnd((IMarker)this.fMarker, (int)(this.fPosition.getOffset() + this.fPosition.getLength()));
                doc.removePosition(this.fPosition);
                this.fPosition = null;
            }
        }

        public IFile getFile() {
            return (IFile)this.fMarker.getResource();
        }

        public int getLength() {
            if (this.fPosition != null) {
                return this.fPosition.getLength();
            }
            return MarkerUtilities.getCharEnd((IMarker)this.fMarker) - MarkerUtilities.getCharStart((IMarker)this.fMarker);
        }

        public int getOffset() {
            if (this.fPosition != null) {
                return this.fPosition.getOffset();
            }
            return MarkerUtilities.getCharStart((IMarker)this.fMarker);
        }
    }
}

