/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesOutlineContentProvider;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class PropertiesContentOutlinePage
extends ContentOutlinePage {
    protected IDocumentProvider fDocumentProvider;
    protected Object fInput;
    protected ITextEditor fTextEditor;

    public PropertiesContentOutlinePage(IDocumentProvider provider, ITextEditor editor) {
        this.fDocumentProvider = provider;
        this.fTextEditor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new PropertiesOutlineContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setSorter(new ViewerSorter());
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            Segment segment = (Segment)((IStructuredSelection)selection).getFirstElement();
            int start = segment.position.getOffset();
            int length = segment.position.getLength();
            try {
                this.fTextEditor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException x) {
                this.fTextEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    protected static class Segment {
        public String name;
        public Position position;

        public Segment(String name, Position position) {
            this.name = name;
            this.position = position;
        }

        public String toString() {
            return this.name;
        }
    }
}

