/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.util.ArrayList;
import java.util.Iterator;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.ColorManager;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesConfiguration;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesDocumentProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class PropertiesEditor
extends TextEditor {
    private ProjectionAnnotationModel annotationModel;
    private ColorManager colorManager = new ColorManager();
    public Boolean initialCollapseOption;

    public PropertiesEditor() {
        this.setSourceViewerConfiguration(new PropertiesConfiguration(this.colorManager, this));
        this.setDocumentProvider((IDocumentProvider)new PropertiesDocumentProvider());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public Color getBackground() {
        return this.getSourceViewer().getTextWidget().getBackground();
    }

    public Font getFont() {
        return this.getSourceViewer().getTextWidget().getFont();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("#PropertiesEditorContext");
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"jp.gr.java_conf.ussiy.app.propedit.scope"});
    }

    public void setBackground(Color color) {
        this.getSourceViewer().getTextWidget().setBackground(color);
    }

    public void setFont(Font font) {
        this.getSourceViewer().getTextWidget().setFont(font);
        if (this.fLineNumberRulerColumn != null) {
            this.fLineNumberRulerColumn.setFont(font);
        }
    }

    public void updateFoldingStructure(ArrayList positions) {
        ArrayList annotationInfoList = new ArrayList();
        Iterator ite = this.annotationModel.getAnnotationIterator();
        while (ite.hasNext()) {
            ProjectionAnnotation annotation = (ProjectionAnnotation)ite.next();
            Position oldPos = this.annotationModel.getPosition((Annotation)annotation);
            boolean removeFlg = true;
            int i = 0;
            while (i < positions.size()) {
                Position newPos = (Position)positions.get(i);
                if (newPos.getOffset() == oldPos.getOffset() && newPos.getLength() == oldPos.getLength()) {
                    removeFlg = false;
                    positions.remove(newPos);
                    break;
                }
                ++i;
            }
            if (!removeFlg) continue;
            this.annotationModel.removeAnnotation((Annotation)annotation);
        }
        if (this.initialCollapseOption == null) {
            IPreferenceStore store = PropertiesEditorPlugin.getDefault().getPreferenceStore();
            this.initialCollapseOption = new Boolean(store.getBoolean("collapseOption"));
            int i = 0;
            while (i < positions.size()) {
                Position pos = (Position)positions.get(i);
                this.annotationModel.addAnnotation((Annotation)new ProjectionAnnotation(this.initialCollapseOption.booleanValue()), pos);
                ++i;
            }
        } else {
            int i = 0;
            while (i < positions.size()) {
                Position pos = (Position)positions.get(i);
                this.annotationModel.addAnnotation((Annotation)new ProjectionAnnotation(), pos);
                ++i;
            }
        }
    }
}

