/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class PropertiesEditorRule
implements IPredicateRule {
    protected char fEscapeCharacter;
    protected char[] fStartSequence;
    protected IToken fToken;

    public PropertiesEditorRule(String startSequence, IToken token, char escapeCharacter) {
        this.fToken = token;
        this.fStartSequence = startSequence.toCharArray();
        this.fEscapeCharacter = escapeCharacter;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int nc = 0;
        int i = 0;
        while (i < this.fStartSequence.length) {
            nc = scanner.read();
            if ((char)nc != this.fStartSequence[i]) {
                int j = 0;
                while (j < i + 1) {
                    scanner.unread();
                    ++j;
                }
                return Token.UNDEFINED;
            }
            ++i;
        }
        while (true) {
            if ((nc = scanner.read()) == -1) {
                return this.getSuccessToken();
            }
            if ((char)nc == this.fEscapeCharacter) {
                nc = scanner.read();
                if ((char)nc == '\n') continue;
                if ((char)nc == '\uffffffff') {
                    return this.getSuccessToken();
                }
                int nc2 = scanner.read();
                if ((char)nc == '\r' && (char)nc2 == '\n') continue;
                if ((char)nc == '\r' && (char)nc2 != '\n') {
                    scanner.unread();
                    continue;
                }
                scanner.unread();
                scanner.unread();
                continue;
            }
            if ((char)nc == '\r' || (char)nc == '\n') break;
        }
        return this.getSuccessToken();
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }
}

