/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.editors.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class ValueRule
implements IPredicateRule {
    protected IToken fToken;
    protected char fSeparateSequence;
    protected char fEscapeCharacter;

    public ValueRule(char separateSequence, IToken token, char escapeCharacter) {
        this.fToken = token;
        this.fSeparateSequence = separateSequence;
        this.fEscapeCharacter = escapeCharacter;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    public void disp(int a) {
        this.disp((char)a);
    }

    public void disp(char a) {
        if (a == '\n') {
            System.out.println("\\n");
        } else if (a == '\r') {
            System.out.println("\\r");
        } else if (a == ' ') {
            System.out.println("\\s");
        } else {
            System.out.println(new char[]{a});
        }
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (scanner.getColumn() == 0) {
            return Token.UNDEFINED;
        }
        scanner.unread();
        int nc = scanner.read();
        boolean escapeFlg = false;
        int unreadCnt = 0;
        if ((char)nc == this.fSeparateSequence) {
            int column;
            int i = column = scanner.getColumn();
            while (i >= 0) {
                scanner.unread();
                scanner.unread();
                ++unreadCnt;
                nc = scanner.read();
                if ((char)nc == this.fEscapeCharacter) {
                    escapeFlg = !escapeFlg;
                    --i;
                    continue;
                }
                break;
            }
        } else {
            return Token.UNDEFINED;
        }
        int j = 0;
        while (j < unreadCnt) {
            scanner.read();
            ++j;
        }
        if (escapeFlg) {
            return Token.UNDEFINED;
        }
        while (true) {
            if ((nc = scanner.read()) == -1) {
                return this.getSuccessToken();
            }
            if ((char)nc == this.fEscapeCharacter) {
                escapeFlg = true;
                while ((nc = scanner.read()) == this.fEscapeCharacter) {
                    if (escapeFlg) {
                        escapeFlg = false;
                        continue;
                    }
                    escapeFlg = true;
                }
                if (escapeFlg) {
                    if ((char)nc == '\n') continue;
                    if ((char)nc == '\uffffffff') {
                        return this.getSuccessToken();
                    }
                    int nc2 = scanner.read();
                    if ((char)nc == '\r' && (char)nc2 == '\n') continue;
                    if ((char)nc == '\r' && (char)nc2 != '\n') {
                        scanner.unread();
                        continue;
                    }
                    scanner.unread();
                    scanner.unread();
                    continue;
                }
                if ((char)nc != '\r' && (char)nc != '\n') continue;
                return this.getSuccessToken();
            }
            if ((char)nc == '\r' || (char)nc == '\n') break;
        }
        return this.getSuccessToken();
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

