/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.editors;

import jp.sf.propdev.PropDevPlugin;
import jp.sf.propdev.editors.NonRuleBasedDamagerRepairer;
import jp.sf.propdev.editors.NotifyingReconciler;
import jp.sf.propdev.editors.PropertiesCommentFormattingStrategy;
import jp.sf.propdev.editors.PropertiesEditorCompletionProcessor;
import jp.sf.propdev.editors.PropertiesReconcilingStrategy;
import jp.sf.propdev.editors.PropertiesTextHover;
import jp.sf.propdev.editors.rules.PropertiesSectionScanner;
import jp.sf.propdev.editors.text.PropertiesAnnotationHover;
import jp.sf.propdev.model.PropertiesNode;
import jp.sf.propdev.utils.ColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;

public class PropertiesConfiguration
extends SourceViewerConfiguration {
    private ColorManager colorManager = PropDevPlugin.getDefault().getColorManager();
    private DefaultTextDoubleClickStrategy doubleClickStrategy;
    private PropertiesNode fPropertiesModel;
    private ITextHover fTextHover;
    private PropertiesSectionScanner sectionScanner;
    private ContentAssistant contentAssistant;

    public PropertiesConfiguration(PropertiesNode editor) {
        this.fPropertiesModel = editor;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new PropertiesAnnotationHover();
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__properties_comment", "__properties_section", "__properties_key"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__dftl_partition_content_type";
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.contentAssistant = new ContentAssistant();
        PropertiesEditorCompletionProcessor processor = new PropertiesEditorCompletionProcessor(this.fPropertiesModel);
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__properties_key");
        this.contentAssistant.setDocumentPartitioning("__dftl_partition_content_type");
        IPreferenceStore store = PropDevPlugin.getDefault().getPreferenceStore();
        String triggers = store.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null) {
            processor.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        this.contentAssistant.enableAutoInsert(store.getBoolean("content_assist_autoinsert"));
        this.contentAssistant.enableAutoActivation(store.getBoolean("content_assist_autoactivation"));
        this.contentAssistant.setAutoActivationDelay(store.getInt("content_assist_autoactivation_delay"));
        this.contentAssistant.setProposalPopupOrientation(10);
        this.contentAssistant.setContextInformationPopupOrientation(20);
        ColorManager manager = PropDevPlugin.getDefault().getColorManager();
        Color background = this.getColor(store, "org.eclipse.ant.ui.codeAssistProposalsBackgroundColor", manager);
        this.contentAssistant.setContextInformationPopupBackground(background);
        this.contentAssistant.setContextSelectorBackground(background);
        this.contentAssistant.setProposalSelectorBackground(background);
        Color foreground = this.getColor(store, "org.eclipse.ant.ui.codeAssistProposalsForegroundColor", manager);
        this.contentAssistant.setContextInformationPopupForeground(foreground);
        this.contentAssistant.setContextSelectorForeground(foreground);
        this.contentAssistant.setProposalSelectorForeground(foreground);
        IInformationControlCreator creator = this.getInformationControlCreator();
        this.contentAssistant.setInformationControlCreator(creator);
        if (sourceViewer instanceof TextViewer) {
            final TextViewer textViewer = (TextViewer)sourceViewer;
            textViewer.appendVerifyKeyListener(new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    if (event.stateMask == 262144 && event.character == ' ') {
                        if (textViewer.canDoOperation(13)) {
                            textViewer.doOperation(13);
                        }
                        event.doit = false;
                    }
                }
            });
        }
        return this.contentAssistant;
    }

    protected IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        };
    }

    private Color getColor(IPreferenceStore store, String key, ColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        formatter.setFormattingStrategy((IFormattingStrategy)new PropertiesCommentFormattingStrategy(), "__properties_comment");
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DefaultTextDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new RuleBasedScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        DefaultDamagerRepairer sdr = new DefaultDamagerRepairer((ITokenScanner)this.getPropertiesSectionScanner());
        reconciler.setDamager((IPresentationDamager)sdr, "__properties_section");
        reconciler.setRepairer((IPresentationRepairer)sdr, "__properties_section");
        NonRuleBasedDamagerRepairer kdr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(ColorManager.PROPERTIES_KEY)));
        reconciler.setDamager((IPresentationDamager)kdr, "__properties_key");
        reconciler.setRepairer((IPresentationRepairer)kdr, "__properties_key");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(ColorManager.PROPERTIES_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__properties_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__properties_comment");
        return reconciler;
    }

    protected PropertiesSectionScanner getPropertiesSectionScanner() {
        if (this.sectionScanner == null) {
            this.sectionScanner = new PropertiesSectionScanner(this.colorManager);
            this.sectionScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.PROPERTIES_SECTION))));
        }
        return this.sectionScanner;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        NotifyingReconciler reconciler = new NotifyingReconciler(new PropertiesReconcilingStrategy(this.fPropertiesModel), true);
        reconciler.setDelay(500);
        return reconciler;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fTextHover == null) {
            this.fTextHover = new PropertiesTextHover();
        }
        return this.fTextHover;
    }
}

