/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.eclipse.plugin.prop2java;

import java.io.IOException;
import jp.co.powerbeans.eclipse.plugin.prop2java.Prop2JavaChanger;
import jp.co.powerbeans.eclipse.plugin.prop2java.properties.Prop2JavaPropertyPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Prop2JavaPlugin
extends AbstractUIPlugin
implements IResourceChangeListener,
IStartup {
    private static Prop2JavaPlugin plugin;

    public Prop2JavaPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Prop2JavaPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"Prop2Java", (String)path);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void earlyStartup() {
    }

    class DeltaPrinter
    implements IResourceDeltaVisitor {
        DeltaPrinter() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            switch (delta.getKind()) {
                case 4: {
                    if (res.getFileExtension() == null) break;
                    try {
                        String conf_prop = Prop2JavaPropertyPage.read("PropertyFilePath", res.getProject());
                        String src_path = Prop2JavaPropertyPage.read("OutputSrcPath", res.getProject());
                        String full_conf_prop = "/" + res.getProject().getName() + "/" + src_path + "/" + conf_prop;
                        if (!full_conf_prop.equals(res.getFullPath().toString())) break;
                        Prop2JavaChanger.exportJava(res.getProject(), conf_prop, src_path, Prop2JavaPropertyPage.read("OutputJavaClass", res.getProject()), Prop2JavaPropertyPage.read("charset", res.getProject()));
                        break;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
    }
}

