/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanseido.teniwoha;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.TextPosition;
import zephyr.util.BIMUtil;

public class PageDivider {
    private final PDFRenderer pdfRenderer;
    private final int dpi;
    private final float[] yRatios;
    private float[] barYs = null;
    private float[] marginXs = null;
    public static int OUT_PART = -1;
    private final float LEMMA_MARGIN = 7.8f;

    PageDivider(PDDocument pDDocument, int n, float[] fArray) {
        this.pdfRenderer = new PDFRenderer(pDDocument);
        this.dpi = n;
        this.yRatios = fArray;
    }

    private float div(int n, int n2) {
        return (float)n / (float)n2;
    }

    private boolean findhorizontalLine(BufferedImage bufferedImage, int n, int n2) {
        int n3 = BIMUtil.horizontalBlackNum(bufferedImage, n - 2);
        n3 += BIMUtil.horizontalBlackNum(bufferedImage, n - 1);
        return (n3 += BIMUtil.horizontalBlackNum(bufferedImage, n)) >= n2;
    }

    private float[] findBarYs(int n, BufferedImage bufferedImage, float f) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 70 * n2 / 100;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n5 = this.dpi / 4;
        block0: for (float f2 : this.yRatios) {
            int n6 = (int)(f2 * (float)n3);
            for (int i = 0; i < n5; ++i) {
                int n7 = n6 + i;
                if (this.findhorizontalLine(bufferedImage, n7, n4)) {
                    linkedList.add(n7);
                    continue block0;
                }
                n7 = n6 - i;
                if (!this.findhorizontalLine(bufferedImage, n7, n4)) continue;
                linkedList.add(n7);
                continue block0;
            }
        }
        System.err.println(n + "\t" + linkedList);
        if (linkedList.size() != 5) {
            System.err.println("\u6a2a\u7dda\u691c\u51fa\u5931\u6557\uff1a\u30da\u30fc\u30b8" + n + "\t" + linkedList.size());
        }
        float[] fArray = new float[linkedList.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.div((Integer)linkedList.get(i), n3) * f;
        }
        return fArray;
    }

    private int findWhiteHorizontal(int n, BufferedImage bufferedImage, int n2, int n3) {
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight() / 1000;
        for (int i = n2; 0 <= i && i < n4; i += n3) {
            int n6 = BIMUtil.verticalBlackNum(bufferedImage, i);
            if (n6 >= n5) continue;
            return i;
        }
        System.err.println("\u7e26\u65b9\u5411\u4f59\u767d\u5931\u6557\uff1a\u30da\u30fc\u30b8" + n);
        return n3 > 0 ? n4 - 1 : 0;
    }

    private float[] findHorizontalMargin(int n, BufferedImage bufferedImage, float f) {
        int n2 = bufferedImage.getWidth();
        int n3 = this.findWhiteHorizontal(n, bufferedImage, n2 / 10, -1);
        int n4 = this.findWhiteHorizontal(n, bufferedImage, n2 - n2 / 10, 1);
        return new float[]{this.div(n3, n2) * f, this.div(n4, n2) * f};
    }

    void processPage(int n, PDPage pDPage) throws IOException {
        BufferedImage bufferedImage = this.pdfRenderer.renderImageWithDPI(n - 1, (float)this.dpi, ImageType.BINARY);
        float f = pDPage.getMediaBox().getWidth();
        float f2 = pDPage.getMediaBox().getHeight();
        this.barYs = this.findBarYs(n, bufferedImage, f2);
        this.marginXs = this.findHorizontalMargin(n, bufferedImage, f);
    }

    int findPart(TextPosition textPosition) {
        float f = textPosition.getX();
        if (f <= this.marginXs[0] || this.marginXs[1] <= f) {
            return OUT_PART;
        }
        float f2 = textPosition.getY() - textPosition.getHeight();
        if (f2 <= this.barYs[0]) {
            return OUT_PART;
        }
        for (int i = 1; i < this.barYs.length; ++i) {
            if (!(f2 < this.barYs[i])) continue;
            return i;
        }
        return OUT_PART;
    }

    boolean isLemma(TextPosition textPosition, int n) {
        float f;
        float f2 = textPosition.getY() - textPosition.getHeight();
        float f3 = f2 - (f = this.barYs[n - 1]);
        return f3 <= 7.8f;
    }
}

