/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.LinkedList;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    static final String ENTRY_DELIM = "======";
    private final HashSet<String> ignorePosts = new HashSet();
    private int nEntry = 0;

    private void fixLines(LinkedList<String> linkedList) {
        String string = linkedList.get(0);
        if (string.startsWith("Draft entry ") || string.startsWith("Additions ")) {
            String string2 = linkedList.get(2);
            linkedList.set(0, string2);
            linkedList.set(2, string);
        }
    }

    private void loadPostfixTxt() throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(new File("postfix.txt"));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("\t") || string.startsWith("#")) continue;
            this.ignorePosts.add(string);
        }
        bufferedReader.close();
    }

    private void divideTitleLine(String string, String[] stringArray) {
        int n = string.indexOf(", ");
        if (n > 0) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n);
            return;
        }
        n = string.lastIndexOf(32);
        if (n < 0) {
            stringArray[0] = string;
            stringArray[1] = null;
            return;
        }
        String string2 = string.substring(n + 1);
        if (this.ignorePosts.contains(string2)) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n);
        } else {
            stringArray[0] = string;
            stringArray[1] = null;
        }
    }

    private void outLines(LinkedList<String> linkedList) {
        if (linkedList.size() < 3) {
            System.err.println("lines.size()=" + linkedList.size());
            return;
        }
        this.fixLines(linkedList);
        String[] stringArray = new String[2];
        String string = linkedList.get(0);
        this.divideTitleLine(string, stringArray);
        if (stringArray[1] != null) {
            System.out.print("<dt title=\"");
            System.out.print(string);
            System.out.print("\">");
            System.out.print(stringArray[0]);
            System.out.print("</dt><dd><i>");
            System.out.print(stringArray[1]);
            System.out.println("</i>");
        } else {
            System.out.print("<dt>");
            System.out.print(string);
            System.out.print("</dt><dd>");
            System.out.println("<br>");
        }
        for (int i = 1; i < linkedList.size(); ++i) {
            String string2 = linkedList.get(i).trim();
            if (string2.isEmpty()) {
                if (i <= 1) continue;
                System.out.println("<br><br>");
                continue;
            }
            System.out.println("<p>" + string2 + "</p>");
        }
        System.out.println("</dd>");
        ++this.nEntry;
    }

    private void loadTxt(File file) throws Exception {
        String string;
        System.err.println(file.getName());
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.replace("\ufeff", "")).equals(ENTRY_DELIM)) {
                this.outLines(linkedList);
                linkedList.clear();
                continue;
            }
            for (String string2 : string.split("\r\r")) {
                string2 = string2.replaceAll("(\\xa0+)([ac\\? ]*[\\xa0\\u2006]*[0-9\\-\u2013]+)", "$1<b>$2</b>");
                string2 = string2.replaceFirst("^([\u2020\u00b6]?(([A-Za-z]|[IVX]+|[0-9]{1,3})\\. )+)", "<b>$1</b>");
                linkedList.add(string2);
            }
        }
        bufferedReader.close();
        if (!linkedList.isEmpty()) {
            this.outLines(linkedList);
        }
    }

    private void loadDir(String[] stringArray) throws Exception {
        File file;
        String string = stringArray.length > 0 ? stringArray[0] : "data";
        File file2 = new File(string);
        System.out.println("<html><body>");
        for (int i = 0; i < 100 && (file = new File(file2, "oed-" + i + ".txt")).exists(); ++i) {
            this.loadTxt(file);
        }
        System.out.println("</body></html>");
        System.err.println(this.nEntry + " entries");
    }

    public static void main(String[] stringArray) {
        ZephyrUtil.setUTF8Ouput();
        MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
        try {
            makeBodyHtml.loadPostfixTxt();
            makeBodyHtml.loadDir(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

