/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import zephyr.util.BIMUtil;
import zephyr.util.ThreadWork;
import zephyr.util.ThreadWorkInvoker;

public class PDF2Jpeg {
    protected int TRIM_MARGIN = 10;
    protected final int dpi;
    private final ImageType IMAGE_TYPE;
    private final String FILE_POSTFIX;
    protected final String OUTPUT_TYPE;
    private final boolean ADD_FILENAME_PREFIX;

    protected PDF2Jpeg(int n) {
        this.dpi = n;
        this.IMAGE_TYPE = ImageType.RGB;
        this.FILE_POSTFIX = ".jpg";
        this.OUTPUT_TYPE = "jpeg";
        this.ADD_FILENAME_PREFIX = true;
    }

    protected PDF2Jpeg(int n, ImageType imageType, String string, String string2, boolean bl) {
        this.dpi = n;
        BIMUtil.setDpi(n);
        this.IMAGE_TYPE = imageType;
        this.FILE_POSTFIX = string;
        this.OUTPUT_TYPE = string2;
        this.ADD_FILENAME_PREFIX = bl;
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
    }

    protected void convert(BufferedImage bufferedImage, File file) throws Exception {
        bufferedImage = BIMUtil.trim(bufferedImage, this.TRIM_MARGIN);
        this.write(bufferedImage, this.OUTPUT_TYPE, file);
    }

    protected void convert(String string, String string2, String string3, int n, int n2, int n3, int n4) throws Exception {
        File file;
        File file2 = new File(string);
        if (!file2.exists()) {
            System.err.println(string + " \u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        if (this.ADD_FILENAME_PREFIX) {
            if (string3 == null) {
                string3 = file2.getName();
                string3 = string3.substring(0, string3.length() - 4);
            }
        } else if (string3 == null) {
            string3 = "";
        }
        if (!(file = new File(string2)).exists()) {
            file.mkdirs();
        }
        System.out.println(string + " \u5909\u63db\u958b\u59cb");
        PDDocument pDDocument = PDDocument.load((File)file2);
        ThreadWorkInvoker threadWorkInvoker = new ThreadWorkInvoker();
        int n5 = n - n3;
        for (LinkedList linkedList : ThreadWorkInvoker.divideIntArrayPara(n3, Integer.min(n4, pDDocument.getNumberOfPages()), ThreadWorkInvoker.THREAD_NUM)) {
            threadWorkInvoker.addWork(new ConvertWork(linkedList, file, pDDocument, n5, string3));
        }
        threadWorkInvoker.runJob();
        pDDocument.close();
        System.out.println();
        System.out.println(string + " \u5909\u63db\u7d42\u4e86");
    }

    protected void write(BufferedImage bufferedImage, String string, File file) throws Exception {
        ImageIO.write((RenderedImage)bufferedImage, this.OUTPUT_TYPE, file);
        System.out.print(file.getName() + " ");
    }

    protected void convert(String string, String string2, String string3, int n, int n2) throws Exception {
        this.convert(string, string2, string3, n, n2, 1, Integer.MAX_VALUE);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java PDF2Jpeg sample.pdf outDir [dpi] [startIdx] [outputPrefix]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 200;
        int n2 = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : -1;
        String string3 = stringArray.length > 4 ? stringArray[4] : null;
        PDF2Jpeg pDF2Jpeg = new PDF2Jpeg(n);
        pDF2Jpeg.convert(string, string2, string3, n2, n);
    }

    private class ConvertWork
    extends ThreadWork {
        private final LinkedList<Integer> pageList;
        private final File outDir;
        private final PDFRenderer pdfRenderer;
        private final int page2idxBias;
        private final String outPrefix;

        ConvertWork(LinkedList<Integer> linkedList, File file, PDDocument pDDocument, int n, String string) {
            this.pageList = linkedList;
            this.outDir = file;
            this.pdfRenderer = new PDFRenderer(pDDocument);
            this.page2idxBias = n;
            this.outPrefix = string;
        }

        @Override
        public void work() throws Exception {
            Iterator iterator = this.pageList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                BufferedImage bufferedImage = this.pdfRenderer.renderImageWithDPI(n - 1, (float)PDF2Jpeg.this.dpi, PDF2Jpeg.this.IMAGE_TYPE);
                String string = this.outPrefix + (n + this.page2idxBias) + PDF2Jpeg.this.FILE_POSTFIX;
                File file = new File(this.outDir, string);
                PDF2Jpeg.this.convert(bufferedImage, file);
            }
        }
    }
}

