/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.encol;

import java.util.HashMap;

public enum POSType {
    NOUN("N", 1),
    PRON("P", 2),
    ADJ("ADJ", 3),
    ADV("ADV", 4),
    VERB("V", 5),
    MD("M", 6),
    PRE("PRE", 7),
    WH("W", 8),
    OTHER("O", 100);

    final String abbr;
    final String abbr2;
    final int order;
    private static final HashMap<String, POSType> tag2posMap;

    private POSType(String string2, int n2) {
        this.abbr = string2;
        this.abbr2 = string2.toLowerCase();
        this.order = n2;
    }

    public static POSType tag2pos(String string) {
        POSType pOSType = tag2posMap.get(string);
        if (pOSType != null) {
            return pOSType;
        }
        return OTHER;
    }

    static {
        tag2posMap = new HashMap();
        tag2posMap.put("NN", NOUN);
        tag2posMap.put("NNP", NOUN);
        tag2posMap.put("NNPS", NOUN);
        tag2posMap.put("NNS", NOUN);
        tag2posMap.put("PRP", PRON);
        tag2posMap.put("PRP$", PRON);
        tag2posMap.put("JJ", ADJ);
        tag2posMap.put("JJR", ADJ);
        tag2posMap.put("JJS", ADJ);
        tag2posMap.put("RB", ADV);
        tag2posMap.put("RBR", ADV);
        tag2posMap.put("RBS", ADV);
        tag2posMap.put("VB", VERB);
        tag2posMap.put("VBD", VERB);
        tag2posMap.put("VBG", VERB);
        tag2posMap.put("VBN", VERB);
        tag2posMap.put("VBP", VERB);
        tag2posMap.put("VBZ", VERB);
        tag2posMap.put("MD", MD);
        tag2posMap.put("IN", PRE);
        tag2posMap.put("RP", PRE);
        tag2posMap.put("TO", PRE);
        tag2posMap.put("WDT", WH);
        tag2posMap.put("WP", WH);
        tag2posMap.put("WP$", WH);
        tag2posMap.put("WRB", WH);
    }
}

