/*
 * Decompiled with CFR 0.152.
 */
package zephyr.iwanami.koujien;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<Character, Character> zenhanMap = new HashMap();
    private static final TreeSet<Character> unknownHanSet = new TreeSet();
    private static final String BR = "<br>";
    private static final HashMap<String, String> eb2htmlMap;
    private static final String EP_DT_START = "<1F09><0001>";
    private static final String EP_ANKER = "<1F09><9999>";
    private static final String EP_BODY_END = "<1F03>";
    private static final String EP_FIGURE = "<x=0,y=0><w=0,h=0>";
    private static final int EPTAG_LEN;
    private final LinkedList<String> closeTags = new LinkedList();
    private static final Pattern EP_REF;
    private static final Pattern EP_AREF;

    MakeBodyHtml() throws Exception {
    }

    private static char zen2han(char c) {
        if ('\uff10' <= c && c <= '\uff19') {
            return (char)(48 + (c - 65296));
        }
        if ('\uff21' <= c && c <= '\uff3a') {
            return (char)(65 + (c - 65313));
        }
        if ('\uff41' <= c && c <= '\uff5a') {
            return (char)(97 + (c - 65345));
        }
        if (c <= '~') {
            return c;
        }
        Character c2 = zenhanMap.get(Character.valueOf(c));
        if (c2 != null) {
            return c2.charValue();
        }
        unknownHanSet.add(Character.valueOf(c));
        return c;
    }

    private String ep2html(String string, HashSet<String> hashSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        int n = string.indexOf(93);
        String[] stringArray = string.substring(1, n).replace(" ", "0").split(":");
        if (stringArray[1].equals("800")) {
            stringArray[0] = String.format("%X", Integer.parseInt(stringArray[0], 16) + 1);
            stringArray[1] = "000";
        }
        String string2 = stringArray[0] + stringArray[1];
        boolean bl2 = hashSet.contains(string2);
        String string3 = string.substring(++n);
        if (!bl2 && string3.startsWith(EP_ANKER)) {
            return "";
        }
        if (string3.contains(EP_FIGURE)) {
            return "";
        }
        boolean bl3 = false;
        block28: while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                String string4;
                switch (string4 = string.substring(n + 1, n + 5)) {
                    case "1FE0": {
                        String string5 = string.substring(n + 7, n + 11);
                        switch (string5) {
                            case "0001": {
                                stringBuilder.append("<i>");
                                this.closeTags.addFirst("</i>");
                                break;
                            }
                            case "0000": 
                            case "0003": 
                            case "0041": {
                                if (bl3) break;
                                stringBuilder.append("<b>");
                                this.closeTags.addFirst("</b>");
                            }
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1FE1": {
                        for (String string6 : this.closeTags) {
                            stringBuilder.append(string6);
                        }
                        this.closeTags.clear();
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F09": {
                        String string5 = string.substring(n);
                        if (string5.startsWith(EP_DT_START)) {
                            if (!this.closeTags.isEmpty()) {
                                System.err.println("missing closeTags before " + string2);
                            }
                            if (bl2) {
                                stringBuilder.append("<dt id=\"" + string2 + "\">");
                                bl2 = false;
                            } else {
                                stringBuilder.append("<dt>");
                            }
                            bl3 = true;
                            n += EP_DT_START.length();
                            break;
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F61": {
                        String string5 = string.substring(n += EPTAG_LEN);
                        if (!string5.equals("<1F0A>") || !bl3) continue block28;
                        stringBuilder.append("</dt><dd><p>");
                        bl3 = false;
                        break;
                    }
                    case "1F04": {
                        bl = false;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F05": {
                        bl = true;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F4A": {
                        stringBuilder.append("\u3000\u97f3\u58f0");
                        n += 3 * EPTAG_LEN;
                        n = string.indexOf(93, n);
                        n = string.indexOf(93, n + 1) + 1;
                        break;
                    }
                    default: {
                        if (string4.compareTo("A121") >= 0 && string4.compareTo("FE7E") <= 0) {
                            stringBuilder.append("&#x");
                            stringBuilder.append(string4);
                            stringBuilder.append(";");
                        } else {
                            Object object = eb2htmlMap.get(string4);
                            if (object != null) {
                                stringBuilder.append((String)object);
                            }
                        }
                        n += EPTAG_LEN;
                        break;
                    }
                }
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append(MakeBodyHtml.zen2han(c));
            }
            ++n;
        }
        String string7 = stringBuilder.toString();
        if (bl3) {
            string7 = string7 + "</dt><dd><p>";
        }
        return string7;
    }

    private HashSet<String> findRefs(String string) throws Exception {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        bufferedReader.readLine();
        bufferedReader.readLine();
        while ((string2 = bufferedReader.readLine()) != null && !string2.endsWith(EP_BODY_END)) {
            Matcher matcher = EP_REF.matcher(string2);
            while (matcher.find()) {
                hashSet.add(matcher.group(1) + matcher.group(2));
            }
        }
        bufferedReader.close();
        System.err.println("found " + hashSet.size() + " unique refs");
        return hashSet;
    }

    private String checkHref(String string, HashSet<String> hashSet) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Matcher matcher = EP_AREF.matcher(string);
        while (matcher.find()) {
            String string2;
            if (n < matcher.start()) {
                stringBuilder.append(string.substring(n, matcher.start()));
            }
            if (hashSet.contains(string2 = matcher.group(2) + matcher.group(3))) {
                stringBuilder.append("<a href=\"#");
                stringBuilder.append(string2);
                stringBuilder.append("\">");
                stringBuilder.append(matcher.group(1));
                stringBuilder.append("</a>");
            } else {
                stringBuilder.append(matcher.group(1));
            }
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    private String normalize(String string, HashSet<String> hashSet) {
        string = this.checkHref(string, hashSet);
        string = string.replace("<p><br>", "<p>");
        string = string.replace("<br></dt>", "</dt>");
        string = string.replace("<br></p>", "</p>");
        string = string.replace('\u3010', '\u3010');
        string = string.replace('\u3011', '\u3011');
        return string;
    }

    private void parse(String string) throws Exception {
        String string2;
        HashSet<String> hashSet = this.findRefs(string);
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        bufferedReader.readLine();
        bufferedReader.readLine();
        StringBuilder stringBuilder = null;
        System.out.println("<html><body>");
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            if (string2.endsWith(EP_BODY_END)) break;
            String string3 = this.ep2html(string2, hashSet);
            if (string3.isEmpty()) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else if (string3.startsWith("<dt") && stringBuilder != null) {
                System.out.println(this.normalize(stringBuilder.toString() + "</p></dd>", hashSet));
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string3);
        }
        bufferedReader.close();
        if (stringBuilder != null) {
            System.out.println(this.normalize(stringBuilder.toString() + "</p></dd>", hashSet));
        }
        System.out.println("</body></html>");
        if (!unknownHanSet.isEmpty()) {
            System.err.println("WARN: Unknown Hankaku characters");
            System.err.println(unknownHanSet.toString());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
            try {
                makeBodyHtml.parse(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml SOME_DIR/koujienX.txt");
        }
    }

    static {
        zenhanMap.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        zenhanMap.put(Character.valueOf('\uff0c'), Character.valueOf(','));
        zenhanMap.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        zenhanMap.put(Character.valueOf('\uff08'), Character.valueOf('('));
        zenhanMap.put(Character.valueOf('\uff09'), Character.valueOf(')'));
        zenhanMap.put(Character.valueOf('\uff3b'), Character.valueOf('['));
        zenhanMap.put(Character.valueOf('\uff3d'), Character.valueOf(']'));
        zenhanMap.put(Character.valueOf('\uff01'), Character.valueOf('!'));
        zenhanMap.put(Character.valueOf('\uff1f'), Character.valueOf('?'));
        zenhanMap.put(Character.valueOf('\uff0b'), Character.valueOf('+'));
        zenhanMap.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0a'), Character.valueOf('*'));
        zenhanMap.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        zenhanMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        zenhanMap.put(Character.valueOf('\uff1a'), Character.valueOf(':'));
        zenhanMap.put(Character.valueOf('\uff1b'), Character.valueOf(';'));
        zenhanMap.put(Character.valueOf('\uff06'), Character.valueOf('&'));
        zenhanMap.put(Character.valueOf('\uff3e'), Character.valueOf('^'));
        zenhanMap.put(Character.valueOf('\uff5c'), Character.valueOf('|'));
        zenhanMap.put(Character.valueOf('\uff1d'), Character.valueOf('='));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        zenhanMap.put(Character.valueOf('\uff05'), Character.valueOf('%'));
        zenhanMap.put(Character.valueOf('\uff5b'), Character.valueOf('{'));
        zenhanMap.put(Character.valueOf('\uff5d'), Character.valueOf('}'));
        String string = "\u30fc\u300a\u300b\u2015\u3008\u3009\u25c6\u00b0\u21d2\u00b4\uff40\u2032\u2033\uffe0\u2026\u4e00\uff1c\uff1e\u00a7\u00a8\u00d7\u2191\u2193\u300c\u300d\uff5e\u2018\uffe3]";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            zenhanMap.put(Character.valueOf(c), Character.valueOf(c));
        }
        eb2htmlMap = new HashMap();
        eb2htmlMap.put("1F0A", BR);
        eb2htmlMap.put("1F42", "{a}");
        eb2htmlMap.put("1F62", "{/a}");
        eb2htmlMap.put("1F06", "<sub>");
        eb2htmlMap.put("1F07", "</sub>");
        eb2htmlMap.put("1F0E", "<sup>");
        eb2htmlMap.put("1F0F", "</sup>");
        EPTAG_LEN = "<xxxx>".length();
        EP_REF = Pattern.compile("<1F62>\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
        EP_AREF = Pattern.compile("\\{a\\}([^\\{\\}]+?)\\{/a\\}\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
    }
}

