/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanseido.teniwoha;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.font.PDVectorFont;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public class DrawPrintTextLocations
extends PDFTextStripper {
    private BufferedImage image;
    private AffineTransform flipAT;
    private AffineTransform rotateAT;
    private AffineTransform transAT;
    private final String filename;
    static final int SCALE = 4;
    private Graphics2D g2d;
    private final PDDocument document;

    public DrawPrintTextLocations(PDDocument pDDocument, String string) throws IOException {
        this.document = pDDocument;
        this.filename = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            DrawPrintTextLocations.usage();
        } else {
            try (PDDocument pDDocument = null;){
                pDDocument = PDDocument.load((File)new File(stringArray[0]));
                DrawPrintTextLocations drawPrintTextLocations = new DrawPrintTextLocations(pDDocument, stringArray[0]);
                drawPrintTextLocations.setSortByPosition(true);
                for (int i = 0; i < pDDocument.getNumberOfPages(); ++i) {
                    drawPrintTextLocations.stripPage(i);
                }
            }
        }
    }

    protected void showGlyph(Matrix matrix, PDFont pDFont, int n, String string, Vector vector) throws IOException {
        super.showGlyph(matrix, pDFont, n, string, vector);
        Shape shape = this.calculateGlyphBounds(matrix, pDFont, n);
        if (shape != null) {
            shape = this.flipAT.createTransformedShape(shape);
            shape = this.rotateAT.createTransformedShape(shape);
            shape = this.transAT.createTransformedShape(shape);
            this.g2d.setColor(Color.CYAN);
        }
    }

    private Shape calculateGlyphBounds(Matrix matrix, PDFont pDFont, int n) throws IOException {
        GeneralPath generalPath = null;
        AffineTransform affineTransform = matrix.createAffineTransform();
        affineTransform.concatenate(pDFont.getFontMatrix().createAffineTransform());
        if (pDFont instanceof PDType3Font) {
            PDRectangle pDRectangle;
            PDType3Font pDType3Font = (PDType3Font)pDFont;
            PDType3CharProc pDType3CharProc = pDType3Font.getCharProc(n);
            if (pDType3CharProc != null && (pDRectangle = pDType3CharProc.getGlyphBBox()) != null) {
                generalPath = pDRectangle.toGeneralPath();
            }
        } else if (pDFont instanceof PDVectorFont) {
            int n2;
            PDTrueTypeFont pDTrueTypeFont;
            PDVectorFont pDVectorFont = (PDVectorFont)pDFont;
            generalPath = pDVectorFont.getPath(n);
            if (pDFont instanceof PDTrueTypeFont) {
                pDTrueTypeFont = (PDTrueTypeFont)pDFont;
                n2 = pDTrueTypeFont.getTrueTypeFont().getHeader().getUnitsPerEm();
                affineTransform.scale(1000.0 / (double)n2, 1000.0 / (double)n2);
            }
            if (pDFont instanceof PDType0Font && (pDTrueTypeFont = (PDType0Font)pDFont).getDescendantFont() instanceof PDCIDFontType2) {
                n2 = ((PDCIDFontType2)pDTrueTypeFont.getDescendantFont()).getTrueTypeFont().getHeader().getUnitsPerEm();
                affineTransform.scale(1000.0 / (double)n2, 1000.0 / (double)n2);
            }
        } else if (pDFont instanceof PDSimpleFont) {
            PDSimpleFont pDSimpleFont = (PDSimpleFont)pDFont;
            String string = pDSimpleFont.getEncoding().getName(n);
            generalPath = pDSimpleFont.getPath(string);
        } else {
            System.out.println("Unknown font class: " + pDFont.getClass());
        }
        if (generalPath == null) {
            return null;
        }
        return affineTransform.createTransformedShape(generalPath.getBounds2D());
    }

    private void stripPage(int n) throws IOException {
        Object object;
        PDFRenderer pDFRenderer = new PDFRenderer(this.document);
        this.image = pDFRenderer.renderImage(n, 4.0f);
        PDPage pDPage = this.document.getPage(n);
        PDRectangle pDRectangle = pDPage.getCropBox();
        this.flipAT = new AffineTransform();
        this.flipAT.translate(0.0, pDPage.getBBox().getHeight());
        this.flipAT.scale(1.0, -1.0);
        this.rotateAT = new AffineTransform();
        int n2 = pDPage.getRotation();
        if (n2 != 0) {
            object = pDPage.getMediaBox();
            switch (n2) {
                case 90: {
                    this.rotateAT.translate(object.getHeight(), 0.0);
                    break;
                }
                case 270: {
                    this.rotateAT.translate(0.0, object.getWidth());
                    break;
                }
                case 180: {
                    this.rotateAT.translate(object.getWidth(), object.getHeight());
                    break;
                }
            }
            this.rotateAT.rotate(Math.toRadians(n2));
        }
        this.transAT = AffineTransform.getTranslateInstance(-pDRectangle.getLowerLeftX(), pDRectangle.getLowerLeftY());
        this.g2d = this.image.createGraphics();
        this.g2d.setStroke(new BasicStroke(0.1f));
        this.g2d.scale(4.0, 4.0);
        this.setStartPage(n + 1);
        this.setEndPage(n + 1);
        object = new OutputStreamWriter(new ByteArrayOutputStream());
        this.writeText(this.document, (Writer)object);
        this.g2d.setStroke(new BasicStroke(0.4f));
        List list = pDPage.getThreadBeads();
        for (PDThreadBead pDThreadBead : list) {
            PDRectangle pDRectangle2 = pDThreadBead.getRectangle();
            Shape shape = pDRectangle2.toGeneralPath().createTransformedShape(this.transAT);
            shape = this.flipAT.createTransformedShape(shape);
            shape = this.rotateAT.createTransformedShape(shape);
            this.g2d.setColor(Color.green);
            this.g2d.draw(shape);
        }
        this.g2d.dispose();
        Object object2 = this.filename;
        int n3 = ((String)object2).lastIndexOf(46);
        object2 = ((String)object2).substring(0, n3) + "-marked-" + (n + 1) + ".png";
        ImageIO.write((RenderedImage)this.image, "png", new File((String)object2));
    }

    protected void writeString(String string, List<TextPosition> list) throws IOException {
        for (TextPosition textPosition : list) {
            System.out.println("String[" + textPosition.getXDirAdj() + "," + textPosition.getYDirAdj() + " fs=" + textPosition.getFontSize() + " xscale=" + textPosition.getXScale() + " height=" + textPosition.getHeightDir() + " space=" + textPosition.getWidthOfSpace() + " width=" + textPosition.getWidthDirAdj() + " len=" + textPosition.getUnicode().length() + "]" + textPosition.getUnicode());
            AffineTransform affineTransform = textPosition.getTextMatrix().createAffineTransform();
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, textPosition.getWidthDirAdj() / textPosition.getTextMatrix().getScalingFactorX(), textPosition.getHeightDir() / textPosition.getTextMatrix().getScalingFactorY());
            Shape shape = affineTransform.createTransformedShape(float_);
            shape = this.flipAT.createTransformedShape(shape);
            shape = this.rotateAT.createTransformedShape(shape);
            this.g2d.setColor(Color.red);
            PDFont pDFont = textPosition.getFont();
            BoundingBox boundingBox = pDFont.getBoundingBox();
            float f = pDFont.getWidth(textPosition.getCharacterCodes()[0]);
            float_ = new Rectangle2D.Float(0.0f, boundingBox.getLowerLeftY(), f, boundingBox.getHeight());
            if (pDFont instanceof PDType3Font) {
                affineTransform.concatenate(pDFont.getFontMatrix().createAffineTransform());
            } else {
                affineTransform.scale(0.001f, 0.001f);
            }
            shape = affineTransform.createTransformedShape(float_);
            shape = this.flipAT.createTransformedShape(shape);
            shape = this.rotateAT.createTransformedShape(shape);
            this.g2d.setColor(Color.blue);
            this.g2d.draw(shape);
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + DrawPrintTextLocations.class.getName() + " <input-pdf>");
    }
}

