/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import org.apache.pdfbox.rendering.ImageType;
import zephyr.util.BIMUtil;
import zephyr.util.BMPCleaner;
import zephyr.util.PDF2Jpeg;

public class PDF2Mono
extends PDF2Jpeg {
    protected final int ignoreDot;
    protected final int cleanRangeDot;
    public static final double DEFAULT_CLEAN_RANGE_MM = 2.0;

    protected PDF2Mono(int n, String string, String string2) {
        super(n, ImageType.BINARY, string, string2, false);
        this.TRIM_MARGIN = Integer.parseInt(System.getProperty("margin", "20"));
        int n2 = Integer.parseInt(System.getProperty("ignoreDot", "-1"));
        double d = Double.parseDouble(System.getProperty("cleanRange", Double.toString(2.0)));
        if (d <= 0.0 || n2 <= 0) {
            this.cleanRangeDot = -1;
            this.ignoreDot = -1;
        } else {
            this.ignoreDot = n2;
            double d2 = BIMUtil.dot2mm((int)Math.sqrt(n2), n);
            double d3 = BIMUtil.dot2mm((int)(2.0 * Math.sqrt((double)n2 / Math.PI)), n);
            this.cleanRangeDot = BIMUtil.mm2dot(d, n);
            System.err.printf("cleanup: ignore %d dots (%.2f[mm] square, %.2f[mm] circle) in %.2fx%.2f[mm](%dx%d dot) square", n2, d2, d3, d, d, this.cleanRangeDot, this.cleanRangeDot);
            System.err.println();
        }
    }

    protected BufferedImage cleanup(BufferedImage bufferedImage) {
        if (this.ignoreDot > 0) {
            BMPCleaner bMPCleaner = new BMPCleaner(this.dpi, this.ignoreDot, this.cleanRangeDot);
            return bMPCleaner.cleanup(bufferedImage);
        }
        return bufferedImage;
    }
}

