/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import zephyr.util.MultiTreeMap;
import zephyr.util.ZephyrUtil;

public class SortLemma {
    private static final HashSet<Character> ignoreChars = new HashSet();
    private final MultiTreeMap<String, LinkedList<String>> lemmaMap = new MultiTreeMap();
    private char lastHead = (char)32;
    private LinkedList<String> lemmaList = null;
    private static final String[][] LIST;

    private String normalize(String string) {
        int n = string.indexOf(44);
        if (n > 0) {
            string = string.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (ignoreChars.contains(Character.valueOf(c))) continue;
            stringBuilder.append(c);
        }
        return ZephyrUtil.dropMarks(stringBuilder.toString()).toLowerCase().trim();
    }

    private void addLemma(String string) {
        String string2 = this.normalize(string);
        if (string2.length() == 0) {
            return;
        }
        char c = string2.charAt(0);
        if ('0' <= c && c <= '9') {
            c = '0';
        }
        if (this.lastHead != c) {
            this.lemmaList = new LinkedList();
            this.lemmaMap.put(string2, this.lemmaList);
            this.lastHead = c;
        }
        this.lemmaList.add(string);
    }

    private void loadFile(File file) throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.equals("======")) {
                bl = false;
                continue;
            }
            if (bl || string.startsWith("Draft entry ") || string.startsWith("Additions ") || string.isEmpty()) continue;
            bl = true;
            this.addLemma(string);
        }
        bufferedReader.close();
    }

    private void output() {
        ListComp listComp = new ListComp();
        for (String[][] stringArray : this.lemmaMap.keySet()) {
            LinkedList linkedList = this.lemmaMap.getList((String)stringArray);
            Collections.sort(linkedList, listComp);
            for (LinkedList object2 : linkedList) {
                System.err.println(object2.size() + "\t" + (String)object2.getFirst() + "\t" + (String)object2.getLast());
            }
        }
        Object object = "";
        for (String[] stringArray : LIST) {
            String string = stringArray[0];
            int n = Integer.parseInt(stringArray[1]);
            System.err.println(string + "\t" + n);
            LinkedList linkedList = (LinkedList)this.lemmaMap.getList(this.normalize(string)).getFirst();
            if (linkedList.size() != n) continue;
            int n2 = 0;
            if (n2 < n && linkedList.get(n2) == object) {
                ++n2;
            }
            if (n2 == n) {
                n2 = 0;
            }
            while (n2 < n) {
                String string2 = (String)linkedList.get(n2);
                System.out.println(this.normalize(string2) + "\t" + string2);
                object = string2;
                ++n2;
            }
        }
    }

    private void loadDir(String string) throws Exception {
        this.lastHead = (char)32;
        this.lemmaList = null;
        System.err.println("check " + string);
        for (int i = 0; i < 50; ++i) {
            File file = new File(string, "oed-" + i + ".txt");
            if (!file.exists()) continue;
            this.loadFile(file);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        SortLemma sortLemma = new SortLemma();
        if (stringArray.length == 0) {
            File file = new File("data");
            for (String string : file.list()) {
                sortLemma.loadDir("data/" + string);
            }
        } else {
            sortLemma.loadDir(stringArray[0]);
        }
        sortLemma.output();
    }

    static {
        String string = " !\"#$%&'()'-=^~\\|@`[{]};+:*<>,./?_\u2020\u02cc\u02c8\u2016\u2014\u00b6\u2006\u2013\u2018\u2032\u2019";
        for (int i = 0; i < string.length(); ++i) {
            ignoreChars.add(Character.valueOf(string.charAt(i)));
        }
        LIST = new String[][]{{"0898 number, n. Brit.", "14"}, {"A", "16585"}, {"B", "15072"}, {"C", "26838"}, {"D", "14897"}, {"E", "10252"}, {"F", "3121"}, {"field, n.", "2"}, {"fieldage rare.", "11499"}, {"G", "7010"}, {"graving, vbl. n.1", "2854"}, {"H", "6237"}, {"hokey-pokey slang or colloq.", "4926"}, {"I", "7861"}, {"integrant, a. (n.)", "676"}, {"inde\u02c8pendentism", "7581"}, {"J", "2383"}, {"K", "3602"}, {"L", "2254"}, {"\u02c8law-a\u02c8biding, a.", "664"}, {"\u2020 \u02c8leafit Obs.", "6877"}, {"M", "13123"}, {"monkey, n.", "4937"}, {"N", "6116"}, {"O", "8139"}, {"P", "20903"}, {"profilograph", "4418"}, {"Q", "1843"}, {"R", "901"}, {"S", "35196"}, {"T", "15977"}, {"U", "737"}, {"umbrella", "12554"}, {"V", "5536"}, {"W", "8964"}, {"X", "164"}, {"Y", "2348"}, {"Z", "780"}};
    }

    private class ListComp
    implements Comparator<LinkedList<String>> {
        private ListComp() {
        }

        @Override
        public int compare(LinkedList<String> linkedList, LinkedList<String> linkedList2) {
            return linkedList2.size() - linkedList.size();
        }
    }
}

