/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.kenkyusha.readers3.ExtraKeys;
import zephyr.kenkyusha.readers3.R3Gaiji;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<Character, Character> zenhanMap = new HashMap();
    private static final TreeSet<Character> unknownHanSet = new TreeSet();
    private final R3Gaiji gaiji;
    private final ExtraKeys extraKeys;
    private static final String RET;
    private static final HashMap<String, String> eb2htmlMap;
    private static final String EP_DT_START = "<1F09><0001><1F41><0160>";
    private static final String EP_ANKER = "<1F09><9999>";
    private static final int EPTAG_LEN;
    private final LinkedList<String> closeTags = new LinkedList();
    private String dtId = "";
    private final HashSet<String> posSet = new HashSet();
    public static final String SUBKEY = "<subkey/>";
    public static final String JP = "";
    public static final String EXMP_EN = "<exmp/>";
    public static final String EXMP_JP = "<exmpjp/>";
    public static final String IDIOM_EN = "<idiom/>";
    public static final String IDIOM_JP = "<idiomjp/>";
    private int nExample = 0;
    private int nIdiom = 0;
    private static final Pattern EP_REF;
    private static final Pattern SMCE_S;
    private static final Pattern SUBSECTION;
    private static final String DD_START = "<dd>";
    private int nEnPostKey = 0;
    private static final Pattern EN_POST;
    private final LinkedList<String> invalidEnKeys = new LinkedList();
    private int nJpKey = 0;
    private static final Pattern JP_PART;
    private static final Pattern DT_DD;

    MakeBodyHtml() throws Exception {
        this.gaiji = new R3Gaiji("GaijiMap.xml");
        this.extraKeys = new ExtraKeys("extrakeys.txt");
    }

    private static char zen2han(char c) {
        if ('\uff10' <= c && c <= '\uff19') {
            return (char)(48 + (c - 65296));
        }
        if ('\uff21' <= c && c <= '\uff3a') {
            return (char)(65 + (c - 65313));
        }
        if ('\uff41' <= c && c <= '\uff5a') {
            return (char)(97 + (c - 65345));
        }
        if (c <= '~') {
            return c;
        }
        Character c2 = zenhanMap.get(Character.valueOf(c));
        if (c2 != null) {
            return c2.charValue();
        }
        unknownHanSet.add(Character.valueOf(c));
        return '#';
    }

    private String ep2html(String string, HashSet<String> hashSet) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        int n = string.indexOf(93);
        String[] stringArray = string.substring(1, n).replace(" ", "0").split(":");
        if (stringArray[1].equals("800")) {
            stringArray[0] = String.format("%X", Integer.parseInt(stringArray[0], 16) + 1);
            stringArray[1] = "000";
        }
        String string3 = stringArray[0] + stringArray[1];
        boolean bl2 = hashSet.contains(string3);
        String string4 = string.substring(++n);
        if (!bl2 && string4.startsWith(EP_ANKER)) {
            return JP;
        }
        boolean bl3 = false;
        if (bl2) {
            string2 = "</p>" + RET + "<p id=\"" + string3 + "\">";
            this.posSet.add(string3);
        } else {
            string2 = "</p>" + RET + "<p>";
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                String string5;
                switch (string5 = string.substring(n + 1, n + 5)) {
                    case "1FE0": {
                        String string6;
                        switch (string6 = string.substring(n + 7, n + 11)) {
                            case "0001": {
                                stringBuilder.append("<i>");
                                this.closeTags.addFirst("</i>");
                                break;
                            }
                            case "0000": 
                            case "0003": {
                                if (bl3) break;
                                stringBuilder.append("<b>");
                                this.closeTags.addFirst("</b>");
                            }
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F09": {
                        String string6;
                        String string7 = string.substring(n);
                        if (string7.startsWith(EP_DT_START)) {
                            if (!this.closeTags.isEmpty()) {
                                System.err.println("missing closeTags before " + string3);
                            }
                            if (bl2) {
                                stringBuilder.append("<dt id=\"" + string3 + "\">");
                                bl2 = false;
                            } else {
                                stringBuilder.append("<dt>");
                            }
                            this.dtId = string3;
                            bl3 = true;
                            n += EP_DT_START.length();
                            break;
                        }
                        switch (string6 = string.substring(n + 7, n + 11)) {
                            case "0002": {
                                break;
                            }
                            case "0003": {
                                stringBuilder.append(string2 + JP);
                                break;
                            }
                            case "0004": {
                                stringBuilder.append(string2 + JP);
                                break;
                            }
                            case "0005": {
                                stringBuilder.append(string2 + "\u3000");
                                break;
                            }
                            case "0020": {
                                stringBuilder.append(string2 + JP);
                                break;
                            }
                            case "0024": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0030": {
                                stringBuilder.append(string2 + JP);
                                break;
                            }
                            case "0103": {
                                stringBuilder.append(string2 + JP);
                                break;
                            }
                            case "0101": {
                                stringBuilder.append(string2 + SUBKEY);
                                break;
                            }
                            case "0104": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0008": 
                            case "0028": 
                            case "0038": {
                                stringBuilder.append(string2 + "\u3000- " + EXMP_EN);
                                ++this.nExample;
                                break;
                            }
                            case "0009": 
                            case "0029": 
                            case "0039": {
                                stringBuilder.append("\u3000<exmpjp/>");
                                break;
                            }
                            case "0106": {
                                stringBuilder.append(string2 + IDIOM_EN);
                                ++this.nIdiom;
                                break;
                            }
                            case "0107": {
                                stringBuilder.append(string2 + "\u3000" + IDIOM_JP);
                                break;
                            }
                            case "0010": 
                            case "0013": 
                            case "0014": 
                            case "0015": 
                            case "0018": 
                            case "0019": 
                            case "0023": 
                            case "0025": 
                            case "0033": 
                            case "0034": 
                            case "0035": 
                            case "0040": 
                            case "0100": 
                            case "0105": 
                            case "0109": 
                            case "0113": 
                            case "0115": 
                            case "0117": 
                            case "0119": 
                            case "0120": 
                            case "0127": 
                            case "0129": 
                            case "9999": {
                                break;
                            }
                            default: {
                                System.err.println("Unknown 1F09 " + string6);
                            }
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F61": {
                        if (bl3) {
                            stringBuilder.append("</dt><dd><p>");
                            bl3 = false;
                        }
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F04": {
                        bl = false;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F05": {
                        bl = true;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1FE1": {
                        for (String string8 : this.closeTags) {
                            stringBuilder.append(string8);
                        }
                        this.closeTags.clear();
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F4A": {
                        stringBuilder.append("\u3000\u97f3\u58f0");
                        n += 3 * EPTAG_LEN;
                        n = string.indexOf(93, n);
                        n = string.indexOf(93, n + 1) + 1;
                        break;
                    }
                    default: {
                        if (string5.compareTo("A121") >= 0 && string5.compareTo("FE7E") <= 0) {
                            stringBuilder.append(this.gaiji.gaiji(string5));
                        } else {
                            String string9 = eb2htmlMap.get(string5);
                            if (string9 != null) {
                                stringBuilder.append(string9);
                            }
                        }
                        n += EPTAG_LEN;
                        break;
                    }
                }
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append(MakeBodyHtml.zen2han(c));
            }
            ++n;
        }
        String string10 = stringBuilder.toString();
        if (bl3) {
            string10 = string10 + "</dt><dd><p>";
        }
        return string10;
    }

    private HashSet<String> findRefs(String string) throws Exception {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        bufferedReader.readLine();
        bufferedReader.readLine();
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = EP_REF.matcher(string2);
            while (matcher.find()) {
                hashSet.add(matcher.group(1) + matcher.group(2));
            }
        }
        bufferedReader.close();
        System.err.println("found " + hashSet.size() + " unique refs");
        return hashSet;
    }

    private String fixSMCES(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Matcher matcher = SMCE_S.matcher(string);
        while (matcher.find()) {
            if (n < matcher.start()) {
                stringBuilder.append(string.substring(n, matcher.start()));
            }
            stringBuilder.append(matcher.group(1).toUpperCase());
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    private String normalize(String string) {
        string = string.replaceAll("(<p[^>]*>)[\u3000 ]*(\\(<b>[0-9]+</b>\\))", "$1\u3000$2");
        string = string.replace("\u25ba", "</p><p>\u25ba");
        string = string.replaceAll("([^ \u3000])\u25c6", "$1\u3000\u25c6");
        string = string.replaceAll("(<p[^>]*>\u3000*<i>[a-z]+</i>(, *<i>[a-z]+</i>)*) *", "$1\u3000");
        string = this.fixSMCES(string);
        string = string.replaceAll("\\{a\\}([^\\{\\}]+?)\\{/a\\}\\[0*([0-9A-F]+):0([0-9A-F]+)\\]", "<a href=\"#$2$3\">$1</a>");
        string = string.replaceAll("[\u3000 ]+</p>", "</p>");
        string = string.replaceAll("<p[^>]*></p>", JP);
        if ((string = string.replace("<p><jp/></p><p>", "<p><jp/>")).length() > 1000) {
            int n = 0;
            Matcher matcher = SUBSECTION.matcher(string);
            StringBuilder stringBuilder = null;
            StringBuilder stringBuilder2 = null;
            int n2 = 0;
            int n3 = 0;
            while (matcher.find()) {
                if (stringBuilder2 == null) {
                    stringBuilder = new StringBuilder();
                    stringBuilder2 = new StringBuilder();
                }
                if (n2 < matcher.start()) {
                    stringBuilder.append(string.substring(n2, matcher.start()));
                }
                String string2 = this.dtId + "." + ++n3;
                if (stringBuilder.length() - n > 50) {
                    stringBuilder.append("<br><br>");
                    n = stringBuilder.length();
                }
                stringBuilder.append("<p id=\"");
                stringBuilder.append(string2);
                stringBuilder.append("\">");
                stringBuilder.append(matcher.group(1));
                if (n3 >= 2) {
                    stringBuilder2.append("\u3000");
                }
                stringBuilder2.append("\u2192<a href=\"#");
                stringBuilder2.append(string2);
                stringBuilder2.append("\">");
                stringBuilder2.append(matcher.group(2));
                stringBuilder2.append("</a>");
                n2 = matcher.end();
            }
            if (stringBuilder != null && n3 >= 2) {
                if (n2 < string.length()) {
                    stringBuilder.append(string.substring(n2));
                }
                string = stringBuilder.toString();
                n2 = string.indexOf(DD_START) + DD_START.length();
                string = string.substring(0, n2) + "<p>" + stringBuilder2.toString().trim() + "</p>" + RET + string.substring(n2).trim();
            }
        }
        return string;
    }

    private String makeKeyList(String string, Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : collection) {
            stringBuilder.append("<key title=\"");
            stringBuilder.append(string2);
            stringBuilder.append(" \uff1c");
            stringBuilder.append(string);
            stringBuilder.append("\uff1e\">");
            stringBuilder.append(string2);
            stringBuilder.append("</key>");
        }
        return stringBuilder.toString();
    }

    private String makeEnKeys(String string, String string2) {
        Matcher matcher = EN_POST.matcher(string2);
        LinkedList<String> linkedList = null;
        String string3 = null;
        while (matcher.find()) {
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
                string3 = string.replaceAll("<sup>.+?</sup>", JP);
                string3 = string3.replaceAll("\u300a.+?\u300b", JP);
            }
            String string4 = matcher.group(1);
            int n = (string4 = string4.replace("-<b>", "-").replace("<b>", JP)).lastIndexOf("</b>");
            if (n > 0) {
                string4 = string4.substring(0, n);
            }
            string4 = string4.replace("</b>", JP);
            string4 = string4.replaceAll("<a[^>]*>", JP).replace("</a>", JP);
            for (String string5 : string4.split(", ")) {
                if (string5.startsWith("-")) {
                    string5 = string5.substring(1);
                    int n2 = string3.lastIndexOf(183);
                    if (n2 < 0) {
                        n2 = string3.lastIndexOf(45);
                    }
                    if (n2 < 0) {
                        if (string3.endsWith("y") && string5.startsWith("i\u00b7n")) {
                            linkedList.add(string3.substring(0, string3.length() - 1) + string5);
                            continue;
                        }
                        if (string3.endsWith("ism") && string5.endsWith("ist")) {
                            linkedList.add(string3.substring(0, string3.length() - 3) + string5);
                            continue;
                        }
                        String[] stringArray = this.extraKeys.keys(string3, string5);
                        if (stringArray != null) {
                            for (String string6 : stringArray) {
                                linkedList.add(string6);
                            }
                            continue;
                        }
                        this.invalidEnKeys.add(string3 + "###" + string5);
                        continue;
                    }
                    linkedList.add(string3.substring(0, n2) + string5);
                    continue;
                }
                if (string5.startsWith("\uff5e") && string5.length() > 1) {
                    linkedList.add(string3 + string5.substring(1));
                    continue;
                }
                if (string5.contains("\uff5e")) continue;
                linkedList.add(string5);
            }
        }
        if (linkedList == null || linkedList.isEmpty()) {
            return null;
        }
        this.nEnPostKey += linkedList.size();
        return this.makeKeyList(string, linkedList);
    }

    private String makeJpKeys(String string, String string2) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Matcher matcher = JP_PART.matcher(string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            string3 = string3.replaceAll("[\u300a\u3018].[\u300b\u3019]", JP);
            string3 = string3.replaceAll("\u2605.+", JP);
            string3 = string3.replaceAll("<a[^>]+>", JP).replaceAll("</a>", JP);
            string3 = string3.replaceAll("<[ib]>.+?</[ib]>", JP);
            for (String string4 : string3.split("[\ue240 \u00b7\\.,;\\[\\]\\(\\)\u3008\u3009\u300a\u300b\u3018\u3019\u2026]+")) {
                if (string4.length() <= 0) continue;
                treeSet.add(string4);
            }
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        this.nJpKey += treeSet.size();
        return this.makeKeyList(string, treeSet);
    }

    private String makeJpKeys(String string) {
        String string2;
        Matcher matcher = DT_DD.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        String string3 = matcher.group(2);
        String string4 = this.makeEnKeys(string3, string2 = string.substring(matcher.end()));
        if (string4 == null) {
            return string;
        }
        return matcher.group(1) + string4 + string2;
    }

    private void parse(String string) throws Exception {
        Object object;
        String string2;
        HashSet<String> hashSet = this.findRefs(string);
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        bufferedReader.readLine();
        bufferedReader.readLine();
        StringBuilder stringBuilder = null;
        System.out.println("<html><body>");
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).isEmpty() || ((String)(object = this.ep2html(string2, hashSet))).isEmpty()) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else if (((String)object).startsWith("<dt") && stringBuilder != null) {
                Iterator iterator = this.makeJpKeys(this.normalize(stringBuilder.toString()) + "</p></dd>");
                System.out.println((String)((Object)iterator));
                stringBuilder = new StringBuilder();
                if (++n % 1000 == 0) {
                    if (n % 10000 == 0) {
                        System.err.print(n / 10000);
                    } else {
                        System.err.print(".");
                    }
                }
            }
            stringBuilder.append((String)object);
        }
        bufferedReader.close();
        if (stringBuilder != null) {
            System.out.println(this.normalize(stringBuilder.toString()) + "</p></dd>");
        }
        System.out.println("</body></html>");
        System.err.println();
        if (!unknownHanSet.isEmpty()) {
            System.err.println("WARN: Unknown Hankaku characters");
            System.err.println(unknownHanSet.toString());
        }
        object = new TreeSet();
        for (String string3 : hashSet) {
            if (this.posSet.contains(string3)) continue;
            ((TreeSet)object).add(string3);
        }
        if (!((TreeSet)object).isEmpty()) {
            System.err.println("WARN: Unknown Pos: " + ((TreeSet)object).size());
            System.err.println(((AbstractCollection)object).toString());
        }
        System.err.println(n + " entries");
        System.err.println("append " + this.nEnPostKey + " English extra keys");
        System.err.println(this.nIdiom + " idioms, " + this.nExample + " example sentenses");
        if (!this.invalidEnKeys.isEmpty()) {
            for (String string3 : this.invalidEnKeys) {
                System.err.println(string3);
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
            try {
                makeBodyHtml.parse(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml SOME_DIR/readers3.txt");
        }
    }

    static {
        zenhanMap.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        zenhanMap.put(Character.valueOf('\uff0c'), Character.valueOf(','));
        zenhanMap.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        zenhanMap.put(Character.valueOf('\uff08'), Character.valueOf('('));
        zenhanMap.put(Character.valueOf('\uff09'), Character.valueOf(')'));
        zenhanMap.put(Character.valueOf('\uff3b'), Character.valueOf('['));
        zenhanMap.put(Character.valueOf('\uff3d'), Character.valueOf(']'));
        zenhanMap.put(Character.valueOf('\uff01'), Character.valueOf('!'));
        zenhanMap.put(Character.valueOf('\uff1f'), Character.valueOf('?'));
        zenhanMap.put(Character.valueOf('\uff0b'), Character.valueOf('+'));
        zenhanMap.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0a'), Character.valueOf('*'));
        zenhanMap.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        zenhanMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        zenhanMap.put(Character.valueOf('\uff1a'), Character.valueOf(':'));
        zenhanMap.put(Character.valueOf('\uff1b'), Character.valueOf(';'));
        zenhanMap.put(Character.valueOf('\uff06'), Character.valueOf('&'));
        zenhanMap.put(Character.valueOf('\uff3e'), Character.valueOf('^'));
        zenhanMap.put(Character.valueOf('\uff5c'), Character.valueOf('|'));
        zenhanMap.put(Character.valueOf('\uff1d'), Character.valueOf('='));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        String string = "\u30fc\u300a\u300b\u2015\u3008\u3009\u25c6\u00b0\u21d2\u00b4\uff40\u2032\u2033\uffe0\u2026\u4e00\uff1c\uff1e\u00a7\u00a8\u00d7\u2191\u2193\u300c\u300d\uff5e\u2018\uffe3]";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            zenhanMap.put(Character.valueOf(c), Character.valueOf(c));
        }
        RET = System.getProperty("line.separator");
        eb2htmlMap = new HashMap();
        eb2htmlMap.put("1F42", "{a}");
        eb2htmlMap.put("1F62", "{/a}");
        eb2htmlMap.put("1F06", "<sub>");
        eb2htmlMap.put("1F07", "</sub>");
        eb2htmlMap.put("1F0E", "<sup>");
        eb2htmlMap.put("1F0F", "</sup>");
        EPTAG_LEN = "<xxxx>".length();
        EP_REF = Pattern.compile("<1F62>\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
        SMCE_S = Pattern.compile("\uff33\uff2d\uff23\uff1a\uff25([^\\[\\]]+?)\uff33\uff2d\uff23\uff1a\uff33");
        SUBSECTION = Pattern.compile("<p>(\u25ba(<i>[^<]+?</i>(, <i>[^<]+?</i>)*))");
        EN_POST = Pattern.compile("<subkey/>(.+)</p>");
        JP_PART = Pattern.compile("(.+?)</p>");
        DT_DD = Pattern.compile("(<dt[^>]*>(.+?)</dt>)");
    }
}

