/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class BIMUtil {
    public static final String RET;
    public static int DEFAULT_TRIM_MARGIN;
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    private static int DPI;
    private static final int TOP_DOT;
    private static final int CENTER_ODD_DOT;
    private static final int CENTER_EVEN_DOT;
    private static final int FIND_SPAN;

    public static BufferedImage trim(BufferedImage bufferedImage) {
        return BIMUtil.trim(bufferedImage, DEFAULT_TRIM_MARGIN);
    }

    public static Rectangle trimRect(BufferedImage bufferedImage, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        for (n5 = 0; n5 < n7; ++n5) {
            if (BIMUtil.isWhiteHorizon(bufferedImage, n5)) continue;
            if ((n5 -= n) >= 0) break;
            n5 = 0;
            break;
        }
        for (n4 = n7 - 1; n4 > n5; --n4) {
            if (BIMUtil.isWhiteHorizon(bufferedImage, n4)) continue;
            ++n4;
            if ((n4 += n) <= n7) break;
            n4 = n7;
            break;
        }
        for (n3 = 0; n3 < n6; ++n3) {
            if (BIMUtil.isWhiteVertical(bufferedImage, n3)) continue;
            if ((n3 -= n) >= 0) break;
            n3 = 0;
            break;
        }
        for (n2 = n6 - 1; n2 > n3; --n2) {
            if (BIMUtil.isWhiteVertical(bufferedImage, n2)) continue;
            ++n2;
            if ((n2 += n) <= n6) break;
            n2 = n6;
            break;
        }
        if (n3 < n2 && n5 < n4) {
            return new Rectangle(n3, n5, n2 - n3, n4 - n5);
        }
        return null;
    }

    public static BufferedImage trim(BufferedImage bufferedImage, int n) {
        Rectangle rectangle = BIMUtil.trimRect(bufferedImage, n);
        if (rectangle != null) {
            return bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return null;
    }

    public static boolean isWhiteHorizon(BufferedImage bufferedImage, int n) {
        return BIMUtil.isWhiteHorizon(bufferedImage, n, 0, bufferedImage.getWidth());
    }

    public static boolean isWhiteHorizon(BufferedImage bufferedImage, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (bufferedImage.getRGB(i, n) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlackHorizon(BufferedImage bufferedImage, int n) {
        return BIMUtil.isBlackHorizon(bufferedImage, n, 0, bufferedImage.getWidth());
    }

    public static boolean isBlackHorizon(BufferedImage bufferedImage, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (bufferedImage.getRGB(i, n) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikeWhiteHorizon(BufferedImage bufferedImage, int n, double d) {
        return BIMUtil.isLikeWhiteHorizon(bufferedImage, n, d, 0, bufferedImage.getWidth());
    }

    public static boolean isLikeWhiteHorizon(BufferedImage bufferedImage, int n, double d, int n2, int n3) {
        int n4 = bufferedImage.getWidth();
        int n5 = (int)(d * (double)n4 / 100.0);
        int n6 = BIMUtil.horizontalBlackNum(bufferedImage, n, n2, n3);
        return n6 <= n5;
    }

    public static boolean isLikeBlackHorizon(BufferedImage bufferedImage, int n, double d) {
        return BIMUtil.isLikeBlackHorizon(bufferedImage, n, d, 0, bufferedImage.getWidth());
    }

    public static boolean isLikeBlackHorizon(BufferedImage bufferedImage, int n, double d, int n2, int n3) {
        int n4 = bufferedImage.getWidth();
        int n5 = (int)(d * (double)n4 / 100.0);
        int n6 = BIMUtil.horizontalBlackNum(bufferedImage, n, n2, n3);
        return n6 >= n5;
    }

    public static boolean isWhiteVertical(BufferedImage bufferedImage, int n) {
        return BIMUtil.isWhiteVertical(bufferedImage, n, 0, bufferedImage.getHeight());
    }

    public static boolean isWhiteVertical(BufferedImage bufferedImage, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (bufferedImage.getRGB(n, i) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isLikeWhiteVertical(BufferedImage bufferedImage, int n, double d) {
        int n2 = bufferedImage.getHeight();
        int n3 = (int)(d * (double)n2 / 100.0);
        int n4 = BIMUtil.verticalBlackNum(bufferedImage, n);
        return n4 <= n3;
    }

    public static boolean isLikeWhiteVertical(BufferedImage bufferedImage, int n, double d, int n2, int n3) {
        int n4 = bufferedImage.getHeight();
        int n5 = (int)(d * (double)n4 / 100.0);
        int n6 = BIMUtil.verticalBlackNum(bufferedImage, n, n2, n3);
        return n6 <= n5;
    }

    public static boolean isBlackVertical(BufferedImage bufferedImage, int n) {
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            if (bufferedImage.getRGB(n, i) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikeBlackVertical(BufferedImage bufferedImage, int n, double d) {
        int n2 = bufferedImage.getHeight();
        int n3 = (int)(d * (double)n2 / 100.0);
        int n4 = BIMUtil.verticalBlackNum(bufferedImage, n);
        return n4 >= n3;
    }

    public static int horizontalBlackNum(BufferedImage bufferedImage, int n) {
        return BIMUtil.horizontalBlackNum(bufferedImage, n, 0, bufferedImage.getWidth());
    }

    public static int horizontalBlackNum(BufferedImage bufferedImage, int n, int n2, int n3) {
        if (n < 0 || bufferedImage.getHeight() <= n) {
            System.err.println("horizontalBlackNum " + n + "\t" + bufferedImage.getHeight());
            return 0;
        }
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            if (bufferedImage.getRGB(i, n) == -1) continue;
            ++n4;
        }
        return n4;
    }

    public static int horizontalWhiteNum(BufferedImage bufferedImage, int n) {
        return bufferedImage.getWidth() - BIMUtil.horizontalBlackNum(bufferedImage, n);
    }

    public static int horizontalWhiteNum(BufferedImage bufferedImage, int n, int n2, int n3) {
        return bufferedImage.getWidth() - BIMUtil.horizontalBlackNum(bufferedImage, n, n2, n3);
    }

    public static boolean isBlack(BufferedImage bufferedImage, int n, int n2) {
        if (0 <= n && n < bufferedImage.getWidth() && 0 <= n2 && n2 < bufferedImage.getHeight()) {
            return bufferedImage.getRGB(n, n2) != -1;
        }
        return false;
    }

    public static boolean isWhite(BufferedImage bufferedImage, int n, int n2) {
        return !BIMUtil.isBlack(bufferedImage, n, n2);
    }

    public static int mm2dot(double d, int n) {
        return (int)(d * (double)n / 25.4);
    }

    public static double dot2mm(int n, int n2) {
        return (double)n * 25.4 / (double)n2;
    }

    public static int verticalBlackNum(BufferedImage bufferedImage, int n) {
        return BIMUtil.verticalBlackNum(bufferedImage, n, 0, bufferedImage.getHeight());
    }

    public static int verticalBlackNum(BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = bufferedImage.getHeight();
        int n5 = 0;
        int n6 = n2;
        while (n3 < n4) {
            if (bufferedImage.getRGB(n, n6) != -1) {
                ++n5;
            }
            ++n6;
        }
        return n5;
    }

    public static int vlineLen(BufferedImage bufferedImage, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            if (BIMUtil.isBlack(bufferedImage, n - 1, i) || BIMUtil.isBlack(bufferedImage, n, i) || BIMUtil.isBlack(bufferedImage, n + 1, i)) {
                ++n2;
                continue;
            }
            if (n2 > n3) {
                n3 = n2;
            }
            n2 = 0;
        }
        return n2 > n3 ? n2 : n3;
    }

    public static int vlineLen(BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = Integer.max(1, n2 / 2);
        int n7 = n - n6;
        int n8 = n7 + n2;
        n7 = Integer.max(0, n7);
        n8 = Integer.min(bufferedImage.getWidth(), n8);
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            int n9 = BIMUtil.horizontalBlackNum(bufferedImage, i, n7, n8);
            if (n9 >= n3) {
                ++n4;
                continue;
            }
            if (n4 > n5) {
                n5 = n4;
            }
            n4 = 0;
        }
        return n4 > n5 ? n4 : n5;
    }

    public static int findVerticalLine(BufferedImage bufferedImage) {
        return BIMUtil.findVerticalLine(bufferedImage, true);
    }

    public static int findVerticalLine(BufferedImage bufferedImage, boolean bl) {
        int n = CENTER_ODD_DOT > 0 && bl ? CENTER_ODD_DOT : (CENTER_EVEN_DOT > 0 && !bl ? CENTER_EVEN_DOT : bufferedImage.getWidth() / 2);
        int n2 = n;
        int n3 = Integer.max(0, n - FIND_SPAN);
        int n4 = Integer.min(n + FIND_SPAN, bufferedImage.getWidth());
        int n5 = 0;
        int n6 = -1;
        for (n = n3; n < n4; ++n) {
            int n7 = BIMUtil.vlineLen(bufferedImage, n);
            if (n7 <= n5) continue;
            n5 = n7;
            n6 = n;
        }
        if (n6 >= 0) {
            return n6;
        }
        return -n2;
    }

    public static int hlineLen(BufferedImage bufferedImage, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            if (BIMUtil.isBlack(bufferedImage, i, n - 1) || BIMUtil.isBlack(bufferedImage, i, n) || BIMUtil.isBlack(bufferedImage, i, n + 1)) {
                ++n2;
                continue;
            }
            if (n2 > n3) {
                n3 = n2;
            }
            n2 = 0;
        }
        return n2 > n3 ? n2 : n3;
    }

    public static int hwhiteLen(BufferedImage bufferedImage, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            if (BIMUtil.isWhite(bufferedImage, i, n - 1) || BIMUtil.isWhite(bufferedImage, i, n) || BIMUtil.isWhite(bufferedImage, i, n + 1)) {
                ++n2;
                continue;
            }
            if (n2 > n3) {
                n3 = n2;
            }
            n2 = 0;
        }
        return n2 > n3 ? n2 : n3;
    }

    public static int hwhiteSumLen(BufferedImage bufferedImage, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            if (BIMUtil.isWhite(bufferedImage, i, n - 1) || BIMUtil.isWhite(bufferedImage, i, n) || BIMUtil.isWhite(bufferedImage, i, n + 1)) {
                ++n3;
                continue;
            }
            if (n3 >= n2) {
                n4 += n3;
            }
            n3 = 0;
        }
        if (n3 >= n2) {
            n4 += n3;
        }
        return n4;
    }

    public static void setDpi(int n) {
        DPI = n;
    }

    public static int findHorizontalLine(BufferedImage bufferedImage) {
        int n;
        int n2;
        if (TOP_DOT > 0) {
            n2 = TOP_DOT - FIND_SPAN;
            n = TOP_DOT + FIND_SPAN;
        } else {
            n2 = 0;
            n = bufferedImage.getWidth() / 5;
        }
        int n3 = 0;
        int n4 = -1;
        for (int i = n2; i < n; ++i) {
            int n5 = BIMUtil.hlineLen(bufferedImage, i);
            if (n5 <= n3) continue;
            n3 = n5;
            n4 = i;
        }
        if (n4 >= 0) {
            return n4;
        }
        return 0;
    }

    public static int[] countHLineLen(BufferedImage bufferedImage) {
        int n = bufferedImage.getHeight();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = BIMUtil.hlineLen(bufferedImage, i);
        }
        return nArray;
    }

    public static ArrayList<Integer> findBarYs(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = n * n3 / 100;
        int[] nArray = BIMUtil.countHLineLen(bufferedImage);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 1; i < n4 - 1; ++i) {
            if (nArray[i - 1] + nArray[i] + nArray[i + 1] < n5) continue;
            arrayList.add(i);
            i += n2;
        }
        return arrayList;
    }

    public static BufferedImage makeSquare(BufferedImage bufferedImage) {
        int n;
        int n2 = bufferedImage.getWidth();
        int n3 = n2 > (n = bufferedImage.getHeight()) ? n2 : n;
        return BIMUtil.makeAtLeastSize(bufferedImage, n3, n3);
    }

    public static BufferedImage makeAtLeastSize(BufferedImage bufferedImage, int n, int n2) {
        int n3;
        int n4;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        if (n5 >= n && n6 >= n2) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        int n7 = (n - n5) / 2;
        int n8 = (n2 - n6) / 2;
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2 - n6; ++n3) {
                bufferedImage2.setRGB(n4, n3, -1);
            }
            for (n3 = n6; n3 < n2; ++n3) {
                bufferedImage2.setRGB(n4, n3, -1);
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n - n5; ++n3) {
                bufferedImage2.setRGB(n3, n4, -1);
            }
            for (n3 = n5; n3 < n; ++n3) {
                bufferedImage2.setRGB(n3, n4, -1);
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                bufferedImage2.setRGB(n4 + n7, n3 + n8, bufferedImage.getRGB(n4, n3));
            }
        }
        return bufferedImage2;
    }

    public static BufferedImage makeScaled(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static double blackRatio(BufferedImage bufferedImage) {
        int n = 0;
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            n += BIMUtil.horizontalBlackNum(bufferedImage, i);
        }
        double d = bufferedImage.getWidth() * bufferedImage.getHeight();
        return (double)n / d;
    }

    public static double bimEquality(BufferedImage bufferedImage, BufferedImage bufferedImage2, double d) {
        int n = 0;
        double d2 = bufferedImage.getWidth() * bufferedImage.getHeight();
        int n2 = (int)((1.0 - d) * d2);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                if (bufferedImage.getRGB(i, j) == bufferedImage2.getRGB(i, j) || ++n < n2) continue;
                return -1.0;
            }
        }
        return (d2 - (double)n) / d2;
    }

    public static BufferedImage clone(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                bufferedImage2.setRGB(i, j, bufferedImage.getRGB(i, j));
            }
        }
        return bufferedImage2;
    }

    public static void dumpBmp(BufferedImage bufferedImage) {
        BIMUtil.dumpBmp(bufferedImage, 0, bufferedImage.getWidth());
    }

    public static void dumpBmp(BufferedImage bufferedImage, int n, int n2) {
        System.out.print(BIMUtil.makeBmpTxt(bufferedImage, n, n2));
    }

    public static String makeBmpTxt(BufferedImage bufferedImage) {
        return BIMUtil.makeBmpTxt(bufferedImage, 0, bufferedImage.getWidth());
    }

    public static String makeBmpTxt(BufferedImage bufferedImage, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t");
        for (n3 = n; n3 < n2; ++n3) {
            stringBuilder.append(n3 % 10);
        }
        stringBuilder.append(RET);
        for (n3 = 0; n3 < bufferedImage.getHeight(); ++n3) {
            stringBuilder.append(n3);
            stringBuilder.append("\t");
            for (int i = n; i < n2; ++i) {
                stringBuilder.append(BIMUtil.isBlack(bufferedImage, i, n3) ? "*" : ".");
            }
            stringBuilder.append(RET);
        }
        return stringBuilder.toString();
    }

    static {
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        RET = System.lineSeparator();
        DEFAULT_TRIM_MARGIN = Integer.parseInt(System.getProperty("margin", "20"));
        DPI = 300;
        TOP_DOT = BIMUtil.mm2dot(Double.parseDouble(System.getProperty("line.top", "0")), DPI);
        CENTER_ODD_DOT = BIMUtil.mm2dot(Double.parseDouble(System.getProperty("line.centerOdd", "0")), DPI);
        CENTER_EVEN_DOT = BIMUtil.mm2dot(Double.parseDouble(System.getProperty("line.centerEven", "0")), DPI);
        FIND_SPAN = BIMUtil.mm2dot(Double.parseDouble(System.getProperty("line.span", "10")), DPI);
    }
}

