/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.royalfrjp;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.util.PDFIndex;
import zephyr.obunsha.util.RefEntry;

public class RoyalPDFRef
extends PDFIndex {
    private final HashMap<Integer, String> page2entMap = new HashMap();
    private static final Pattern APPENDIX = Pattern.compile("\\.pdf','APPENDIX'\\)\">p.([0-9]+)[^<>]+");

    @Override
    public void handleLine(String string, RefEntry refEntry) {
        int n = refEntry.start;
        int n2 = 0;
        while (n <= refEntry.end) {
            this.page2entMap.put(n, refEntry.jpgs[n2]);
            ++n;
            ++n2;
        }
    }

    private void appendRef(StringBuilder stringBuilder, int n) {
        String string = this.page2entMap.get(n);
        if (string != null) {
            stringBuilder.append(" <jpgref id=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"/>");
        } else {
            System.err.println("\u30da\u30fc\u30b8\u756a\u53f7\u4e0d\u6b63\uff1a" + n);
        }
    }

    private String handleRef(String string) {
        Matcher matcher = APPENDIX.matcher(string);
        StringBuilder stringBuilder = null;
        int n = 0;
        while (matcher.find()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string.substring(n, matcher.end()));
            int n2 = Integer.parseInt(matcher.group(1));
            if (n2 == 732 || n2 == 733) {
                this.appendRef(stringBuilder, 732);
                this.appendRef(stringBuilder, 733);
            } else {
                this.appendRef(stringBuilder, n2);
            }
            n = matcher.end();
        }
        if (stringBuilder == null) {
            return string;
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    String makeRef(String string) {
        string = this.handleRef(string);
        return string;
    }
}

